% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/name.R
\name{name}
\alias{name}
\alias{name_get}
\alias{name_images}
\alias{name_minsuptaxa}
\alias{name_search}
\alias{name_taxonomy}
\alias{name_taxonomy_many}
\alias{name_taxonomy_sources}
\title{Perform actions with names.}
\usage{
name_get(uuid, options = NULL, ...)

name_images(uuid, subtaxa = NULL, supertaxa = NULL, other = FALSE,
  options = NULL, ...)

name_minsuptaxa(uuid, options = NULL, ...)

name_search(text, options = NULL, as = "table", ...)

name_taxonomy(uuid, subtaxa = NULL, supertaxa = NULL,
  useUBio = FALSE, options = NULL, as = "table", ...)

name_taxonomy_many(uuid, options = NULL, as = "table", ...)

name_taxonomy_sources(uuid, options = NULL, as = "list", ...)
}
\arguments{
\item{uuid}{One or more name UUIDs.}

\item{options}{(character) One or more of citationStart, html, namebankID, root, string,
type, uid, uri, and/or votes}

\item{...}{curl options passed on to \link[crul:HttpClient]{crul::HttpClient}}

\item{subtaxa}{If immediate, returns data for immediate subtaxa ("children").
Otherwise, does not include subtaxa.}

\item{supertaxa}{If immediate, returns data for immediate supertaxa ("parents").
If all, returns data for all supertaxa ("ancestors"). Otherwise, does not
include supertaxa.}

\item{other}{If set to \code{TRUE}, includes related taxa in the search.}

\item{text}{(character) The text string to search on.}

\item{as}{(character) What to return. One of table (default, a data.frame), list, or json.}

\item{useUBio}{(logical) If TRUE, and there is pending data from uBio that needs to be cached,
a list of commands will be passed back instead of the normal result.}
}
\description{
Perform actions with names.
}
\details{
I'm not adding methods for modifying names, including add, edit, or toggle, because
I can't imagine doing those things from R. Am I wrong?

Options for the \code{options} parameter:
\itemize{
\item citationStart: (optional) Integer Indicates where in the string the citation starts.
May be null.
\item html: (optional) StringHTML version of the name.
\item namebankID: (optional) StringuBio Namebank identifier. May be null.
\item root: (optional) Boolean If true, this name has no hyperonyms (names of supertaxa).
(Should only be true for Panbiota/Vitae.)
\item string: (optional) String The text of the name, including the citation, if any.
\item type: (optional) String Either "scientific or "vernacular.
\item uid: (always) String Universally unique identifier.
\item uri: (optional) String The unique URI associated with the name.
\item votes: (optional) Integer The number of votes this name has received. (Currently unused.)
}
}
\examples{
\dontrun{
# parse as different outputs
name_taxonomy(uuid = "f3254fbd-284f-46c1-ae0f-685549a6a373", 
   options = "string", as="table")
name_taxonomy(uuid = "f3254fbd-284f-46c1-ae0f-685549a6a373", 
   options = "string", as="list")
name_taxonomy(uuid = "f3254fbd-284f-46c1-ae0f-685549a6a373", 
   options = "string", as="json")

# Get info on a name
id <- "1ee65cf3-53db-4a52-9960-a9f7093d845d"
name_get(uuid = id)
name_get(uuid = id, options=c('citationStart','html'))
name_get(uuid = id, options=c('namebankID','root','votes'))

# Searches for images for a taxonomic name.
name_images(uuid = "1ee65cf3-53db-4a52-9960-a9f7093d845d")
name_images(uuid = "1ee65cf3-53db-4a52-9960-a9f7093d845d", 
   options='credit')

# Finds the minimal common supertaxa for a list of names.
name_minsuptaxa(uuid=c("1ee65cf3-53db-4a52-9960-a9f7093d845d",
   "08141cfc-ef1f-4d0e-a061-b1347f5297a0"))

# Finds the taxa whose names match a piece of text.
name_search(text = "Homo sapiens")
name_search(text = "Homo sapiens", options = "names")
name_search(text = "Homo sapiens", options = "type")
name_search(text = "Homo sapiens", options = "namebankID")
name_search(text = "Homo sapiens", options = "root")
name_search(text = "Homo sapiens", options = "uri")
name_search(text = "Homo sapiens", options = c("string","type","uri"))

# Collects taxonomic data for a name.
name_taxonomy(uuid = "f3254fbd-284f-46c1-ae0f-685549a6a373", 
   options = "string")
name_taxonomy(uuid = "f3254fbd-284f-46c1-ae0f-685549a6a373", 
   supertaxa="immediate", options=c("string","namebankID"))
name_taxonomy(uuid = "f3254fbd-284f-46c1-ae0f-685549a6a373", supertaxa="all", 
   options="string")
name_taxonomy(uuid = "f3254fbd-284f-46c1-ae0f-685549a6a373", supertaxa="all", 
   options=c("string","uri"))

# Collects taxonomic data for multiple names.
name_taxonomy_many(uuid = c("f3254fbd-284f-46c1-ae0f-685549a6a373", 
 "1ee65cf3-53db-4a52-9960-a9f7093d845d"))

# Collects data about the sources for a name's taxonomy.
name_taxonomy_sources(uuid = "f3254fbd-284f-46c1-ae0f-685549a6a373")
name_taxonomy_sources(uuid = "f3254fbd-284f-46c1-ae0f-685549a6a373", 
  as="json")
name_taxonomy_sources(uuid = "1ee65cf3-53db-4a52-9960-a9f7093d845d")
}
}
