% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/msa.R
\name{informative.regions.msa}
\alias{informative.regions.msa}
\title{Get informative regions of an alignment}
\usage{
informative.regions.msa(x, min.numspec, spec = NULL,
  refseq = names.msa(x)[1], gaps.inf = FALSE)
}
\arguments{
\item{x}{An object of type \code{msa}.}

\item{min.numspec}{The minimum number of species with non-missing data
required for an alignment column to be considered informative.}

\item{spec}{A character vector of species names, or an integer vector
of species indices.  Only data in
the named species count towards deciding if a site is informative.  The
default value of \code{NULL} implies use all species in the alignment.}

\item{refseq}{Defines the frame of reference for the return value.  Should
be a character vector with the name of one of the sequences in the
alignment, or NULL to indicate use the frame of reference of the entire
alignment.}

\item{gaps.inf}{Logical value indicating whether a gap should be considered
informative.  The default value of \code{FALSE} indicates that gaps as
well as missing data are not counted as informative.}
}
\value{
An object of type \code{feat} indicating the regions of the
alignment which meet the informative criteria.  Note that unless
\code{refseq==NULL}, columns with gaps in the reference
sequence will be ignored, and will fall in "informative" or "uninformative"
features based on the informativeness of neighboring columns.
}
\description{
Get informative regions of an alignment
}
\note{
\itemize{
\item{If the msa object has an idx.offset, it is assumed to be a coordinate
offset for the first species in the alignment.  So the idx.offset will
be added to the coordinates in the returned features object only if
\code{refseq==names.msa(x)[1]}.}
\item{This function will not alter the value of x even if it is stored as
a pointer.}}
}
\examples{
require("rphast")
m <- msa(seqs=c("A--ACGTAT-", "AG-AGGTAA-", "AGGAGGTA--"),
         names=c("human", "mouse", "rat"))
informative.regions.msa(m, 1, refseq=NULL)
informative.regions.msa(m, 3, refseq=NULL)
informative.regions.msa(m, 3, refseq="mouse", spec=c("mouse", "rat"))
}
\author{
Melissa J. Hubisz and Adam Siepel
}
\keyword{msa}

