% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diagnose.R
\name{SitemFit1}
\alias{SitemFit1}
\title{Compute the S fit statistic for 1 item}
\usage{
SitemFit1(grp, item, free = 0, ..., method = "pearson", log = TRUE,
  qwidth = 6, qpoints = 49L, alt = FALSE, omit = 0L, .twotier = TRUE)
}
\arguments{
\item{grp}{a list with spec, param, mean, cov, and data}

\item{item}{the item of interest}

\item{free}{the number of free parameters involved in estimating the item (to adjust the df)}

\item{...}{Not used.  Forces remaining arguments to be specified by name.}

\item{method}{whether to use a pearson or rms test}

\item{log}{whether to return pvalues in log units}

\item{qwidth}{the positive width of the quadrature in Z units}

\item{qpoints}{the number of quadrature points}

\item{alt}{whether to include the item of interest in the denominator}

\item{omit}{number of items to omit or a character vector with the names of the items to omit when calculating the observed and expected sum-score tables}

\item{.twotier}{whether to enable the two-tier optimization}
}
\description{
Implements the Kang & Chen (2007) polytomous extension to
S statistic of Orlando & Thissen (2000). Rows with
missing data are ignored, but see the \code{omit} option.
}
\details{
This statistic is good at finding a small number of misfitting
items among a large number of well fitting items. However, be
aware that misfitting items can cause other items to misfit.

Observed tables cannot be computed when data is
missing. Therefore, you can optionally omit items with the
greatest number of responses missing relative to the item of
interest.

Pearson is slightly more powerful than RMS in most cases I
examined.

Setting \code{alt} to \code{TRUE} causes the tables to match
published articles. However, the default setting of \code{FALSE}
probably provides slightly more power when there are less than 10
items.

The name of the test, "S", probably stands for sum-score.
}
\references{
Kang, T. and Chen, T. T. (2007). An investigation of
the performance of the generalized S-Chisq item-fit index for
polytomous IRT models. ACT Research Report Series.

Orlando, M. and Thissen, D. (2000). Likelihood-Based
Item-Fit Indices for Dichotomous Item Response Theory Models.
\emph{Applied Psychological Measurement, 24}(1), 50-64.
}
