% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class_design.R
\name{getDesignConditionalDunnett}
\alias{getDesignConditionalDunnett}
\title{Get Design Conditional Dunnett Test}
\usage{
getDesignConditionalDunnett(
  alpha = 0.025,
  informationAtInterim = 0.5,
  secondStageConditioning = TRUE
)
}
\arguments{
\item{alpha}{The significance level alpha, default is \code{0.025}. Must be a positive numeric of length 1.}

\item{informationAtInterim}{The information to be expected at interim, default is \code{informationAtInterim = 0.5}.}

\item{secondStageConditioning}{The way the second stage p-values are calculated within the closed system of hypotheses.
If \code{secondStageConditioning = FALSE} is specified, the unconditional adjusted p-values are used, otherwise
conditional adjusted p-values are calculated, default is \code{secondStageConditioning = TRUE}
(for details, see Koenig et al., 2008).}
}
\value{
Returns a \code{\link{TrialDesign}} object.
The following generics (R generic functions) are available for this result object:
\itemize{
  \item \code{\link[=names.FieldSet]{names()}} to obtain the field names,
  \item \code{\link[=print.FieldSet]{print()}} to print the object,
  \item \code{\link[=summary.ParameterSet]{summary()}} to display a summary of the object,
  \item \code{\link[=plot.TrialDesign]{plot()}} to plot the object,
  \item \code{\link[=as.data.frame.TrialDesign]{as.data.frame()}} to coerce the object to a \code{\link[base]{data.frame}},
  \item \code{\link[=as.matrix.FieldSet]{as.matrix()}} to coerce the object to a \code{\link[base]{matrix}}.
}
}
\description{
Defines the design to perform an analysis with the conditional Dunnett test.
}
\details{
For performing the conditional Dunnett test the design must be defined through this function.
You can define the information fraction and the way of how to compute the second stage
p-values only in the design definition, and not in the analysis call.\cr
See \code{\link[=getClosedConditionalDunnettTestResults]{getClosedConditionalDunnettTestResults()}} 
for an example and Koenig et al. (2008) and
Wassmer & Brannath (2016), chapter 11 for details of the test procedure.
}
\section{How to get help for generic functions}{

Click on the link of a generic in the list above to go directly to the help documentation of 
the \code{rpact} specific implementation of the generic. 
Note that you can use the R function \code{\link[utils]{methods}} to get all the methods of a generic and 
to identify the object specific name of it, e.g., 
use \code{methods("plot")} to get all the methods for the \code{plot} generic. 
There you can find, e.g., \code{plot.AnalysisResults} and 
obtain the specific help documentation linked above by typing \code{?plot.AnalysisResults}.
}

\seealso{
Other design functions: 
\code{\link{getDesignCharacteristics}()},
\code{\link{getDesignFisher}()},
\code{\link{getDesignGroupSequential}()},
\code{\link{getDesignInverseNormal}()},
\code{\link{getGroupSequentialProbabilities}()},
\code{\link{getPowerAndAverageSampleNumber}()}
}
\concept{design functions}
