context("tinytest roclet")

test_that("@tests captures tests", {
  out <- roxygen2::roc_proc_text(tinytest_roclet(), "
    #' @tests 
    #' expect_equal(2, 2)
    #'
    NULL")
  expect_equal(length(out), 2)
  expect_equal(length(out$tests), 1)
  expect_equal(length(out$testexamples), 0)
  
  out <- out$tests[[1]]
  
  # # Generated by roxytest: Do not edit by hand!
  #
  # expect_equal(2, 2)
  
  expect_match(out, "^# Generated by roxytest: Do not edit by hand!")
  expect_false(grepl('context("', out, fixed = TRUE))
  expect_false(grepl('testthat("', out, fixed = TRUE))
  expect_match(out, "expect_equal(2, 2)", fixed = TRUE)
})

test_that("@testexamples captures tests", {
  out <- roxygen2::roc_proc_text(tinytest_roclet(), "
    #' @testexamples 
    #' expect_equal(2, 2)
    #'
    NULL")
  
  expect_equal(length(out), 2)
  expect_equal(length(out$tests), 0)
  expect_equal(length(out$testexamples), 1)
  
  out <- out$testexamples[[1]]
  
  # # Generated by roxytest: Do not edit by hand!
  #
  # expect_equal(2, 2)
  
  expect_match(out, "^# Generated by roxytest: Do not edit by hand!")
  expect_false(grepl('context("', out, fixed = TRUE))
  expect_false(grepl('testthat("', out, fixed = TRUE))
  expect_match(out, "expect_equal(2, 2)", fixed = TRUE)
})

test_that("All good @tests", {
  out <- roxygen2::roc_proc_text(tinytest_roclet(), "
    #' Summing two numbers
    #'
    #' @param x A number
    #' @param y Another number
    #' 
    #' @tests 
    #' expect_equal(f(0, 0), 0)
    #' expect_equal(f(2, 3), 5)
    f <- function(x, y) {
      x + y
    }")
  
  expect_equal(length(out), 2)
  expect_equal(length(out$tests), 1)
  expect_equal(length(out$testexamples), 0)
  
  out <- out$tests[[1]]
  
  expect_match(out, "^# Generated by roxytest: Do not edit by hand!")
  expect_false(grepl('context("', out, fixed = TRUE))
  expect_false(grepl('testthat("', out, fixed = TRUE))
  expect_match(out, 'expect_equal(f(0, 0), 0)', fixed = TRUE)
  expect_match(out, 'expect_equal(f(2, 3), 5)', fixed = TRUE)
})

test_that("All good @testexamples", {
  out <- roxygen2::roc_proc_text(tinytest_roclet(), "
    #' Summing two numbers
    #'
    #' @examples 
    #' x <- 2
    #' 
    #' @testexamples
    #' expect_equal(x, 2)
    f <- function(x, y) {
      x + y
    }")
  expect_equal(length(out), 2)
  expect_equal(length(out$tests), 0)
  expect_equal(length(out$testexamples), 1)
  
  out <- out$testexamples[[1]]
  
  expect_match(out, "^# Generated by roxytest: Do not edit by hand!")
  expect_false(grepl('context("', out, fixed = TRUE))
  expect_false(grepl('testthat("', out, fixed = TRUE))
  expect_match(out, 'x <- 2', fixed = TRUE)
  expect_match(out, 'expect_equal(x, 2)', fixed = TRUE)
})

test_that("No @tests is ignored", {
  out <- roxygen2::roc_proc_text(tinytest_roclet(), "
    #' Summing two numbers
    #'
    #' @param x A number
    #' @param y Another number
    f <- function(x, y) {
      x + y
    }")
  expect_equal(out, list(tests = list(), testexamples = list()))
})


test_that("Multiple functions", {
  out <- roxygen2::roc_proc_text(tinytest_roclet(), "
                                 #' A function to do x
#' 
#' @param x A number
#' 
#' @tests 
#' expect_equal(foo(2), sqrt(2))
#' expect_error(foo(\"a string\"))
#' 
#' @return something
foo <- function(x) {
  return(sqrt(x))
}

#' A function to do y
#' 
#' @param x Character vector
#' @param y Character vector
#' 
#' @tests 
#' expect_equal(bar(\"A\", \"B\"), paste(\"A\", \"B\", sep = \"/\"))
#' 
#' @export
bar <- function(x, y) {
  paste0(x, \"/\", y)
}

#' A function with missing parameter docs
#' 
#' @param x Character vector
#' 
#' @export
foobar <- function(x, y) {
  paste0(x, \"/\", y)
}
")
  expect_equal(length(out), 2)
  expect_equal(length(out$tests), 1)
  expect_equal(length(out$testexamples), 0)
  out <- out$tests[[1]]
  
  expect_match(out, "^# Generated by roxytest: Do not edit by hand!")
  expect_match(out, 'Function foo() @', fixed = TRUE)
  expect_match(out, 'Function bar() @', fixed = TRUE)
  expect_false(grepl('Function foobar() @', out, fixed = TRUE))
})


# https://github.com/mikldk/roxytest/issues/12
test_that("Remove content in \\donttest{} and \\dontrun{}", {
  out <- roxygen2::roc_proc_text(tinytest_roclet(), "
    #' Summing two numbers
    #'
    #' @examples 
    #' x <- 2
    #' \\donttest{
    #' a <- 3
    #' }
    #' \\dontrun{
    #' b <- runinf(1e6)
    #' hist(b)
    #' }
    #' 
    #' @testexamples
    #' expect_equal(x, 2)
    f <- function(x, y) {
      x + y
    }")
  expect_equal(length(out), 2)
  expect_equal(length(out$tests), 0)
  expect_equal(length(out$testexamples), 1)
  
  out <- out$testexamples[[1]]
  
  expect_match(out, "^# Generated by roxytest: Do not edit by hand!")
  expect_match(out, 'x <- 2', fixed = TRUE)
  expect_match(out, 'expect_equal(x, 2)', fixed = TRUE)
  
  expect_false(grepl('donttest', out, fixed = TRUE))
  expect_match(out, 'a <-', fixed = TRUE)
  expect_false(grepl('dontrun', out, fixed = TRUE))
  expect_false(grepl('b <-', out, fixed = TRUE))
  expect_false(grepl('hist(b)', out, fixed = TRUE))
})
