% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tag-metadata.R
\name{tags-namespace}
\alias{tags-namespace}
\alias{@evalNamespace}
\alias{@export}
\alias{@exportClass}
\alias{@exportMethod}
\alias{@exportPattern}
\alias{@exportS3Method}
\alias{@import}
\alias{@importClassesFrom}
\alias{@importFrom}
\alias{@importMethodsFrom}
\alias{@rawNamespace}
\alias{@useDynLib}
\title{Tags for managing the \code{NAMESPACE}}
\usage{
#' @evalNamespace {r-code}
#' @export
#' @exportClass {class}
#' @exportMethod {generic}
#' @exportPattern {pattern}
#' @exportS3Method pkg::generic
#' @import {package}
#' @importClassesFrom {package} {class}
#' @importFrom {package} {function}
#' @importMethodsFrom {package} {generic}
#' @rawNamespace {namespace directives}
#' @useDynLib {package}
}
\description{
Learn full the details in in \code{vignette('namespace')}.

Key tags:
\itemize{
\item \verb{@export}: Export this function, method, generic, or class so it's available outside of the package.
\item \verb{@exportS3Method pkg::generic}: Export an S3 method. Only needed when the method is for a generic from a suggested package.
\item \verb{@importFrom \{package\} \{function\}}: Import specific functions from a package.
\item \verb{@useDynLib \{package\}}: Import compiled code from another package.
}

Other less frequently used tags:
\itemize{
\item \verb{@evalNamespace \{r-code\}}: Evaluate arbitrary code in the package namespace and insert the results into the \code{NAMESPACE}. Should return a character vector of directives.
\item \verb{@exportClass \{class\}}: Export an S4 class. For expert use only; in most cases you should use \verb{@export} so roxygen2 can automatically generate the correct directive.
\item \verb{@exportMethod \{generic\}}: Export S4 methods. For expert use only; in most cases you should use \verb{@export} so roxygen2 can automatically generate the correct directive.
\item \verb{@exportPattern \{pattern\}}: Export all objects matching a regular expression.
\item \verb{@import \{package\}}: Import all functions from a package. Use with extreme care.
\item \verb{@importClassesFrom \{package\} \{class\}}: Import S4 classes from another package.
\item \verb{@importMethodsFrom \{package\} \{generic\}}: Import S4 methods from a package.
\item \verb{@rawNamespace \{namespace directives\}}: Insert literal text directly into the \code{NAMESPACE}.
}
}
