% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flat_table_read.R
\name{read_flat_table_file}
\alias{read_flat_table_file}
\title{Import flat table file}
\usage{
read_flat_table_file(name, file, sep = ",", page = NULL, unknown_value = NULL)
}
\arguments{
\item{name}{A string, flat table name.}

\item{file}{A string, name of a text file.}

\item{sep}{Column separator character.}

\item{page}{A string, name of the new field in which to include the name of
the file.}

\item{unknown_value}{A string, value used to replace empty and NA values in
attributes.}
}
\value{
A \code{flat_table} object.
}
\description{
Reads a text file and creates a \code{flat_table} object. The file is expected to
contain a flat table whose first row contains the name of the columns. All
columns are considered to be of type String.
}
\details{
When multiple files are handled, the file name may contain information
associated with the flat table, it could be the table page information if the
name of a new field in which to store it is indicated in the page parameter.

We can also indicate the value that is used in the data with undefined values.
}
\examples{

file <-
  system.file("extdata",
              "mrs_122_us_cities_1962_2016_new.csv",
              package = "rolap")

ft <- read_flat_table_file('mrs_new', file)

}
\seealso{
\code{\link{star_database}}

Other flat table definition functions: 
\code{\link{as_star_database}()},
\code{\link{flat_table}()},
\code{\link{get_table}()},
\code{\link{get_unknown_value_defined}()},
\code{\link{get_unknown_values}()},
\code{\link{read_flat_table_folder}()}
}
\concept{flat table definition functions}
