% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/constellation.R
\name{constellation}
\alias{constellation}
\title{\code{constellation} S3 class}
\usage{
constellation(name = NULL, stars = NULL)
}
\arguments{
\item{name}{A string.}

\item{stars}{A list of \code{star_database} objects.}
}
\value{
A \code{constellation} object.
}
\description{
Creates a \code{constellation} object from a list of \code{star_database} objects. All
dimensions with the same name in the star schemas have to be conformable
(share the same structure, even though they have different instances).
}
\examples{

db1 <- star_database(mrs_cause_schema, ft_num) |>
  snake_case()
db2 <- star_database(mrs_age_schema, ft_age) |>
  snake_case()
ct <- constellation("MRS", list(db1, db2))

}
\seealso{
\code{\link{as_tibble_list}}, \code{\link{as_dm_class}}

Other star database and constellation definition functions: 
\code{\link{snake_case}()},
\code{\link{star_database}()}
}
\concept{star database and constellation definition functions}
