% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rocker-S3-functions.R
\name{setupSQLite}
\alias{setupSQLite}
\title{Setup database driver and define connection parameters for SQLite using \link[RSQLite:SQLite]{RSQLite} package.
Wrapper for setupDriver() function.}
\usage{
setupSQLite(db, dbname = ":memory:", protect = c("password", "user"), ...)
}
\arguments{
\item{db}{rocker object}

\item{dbname}{Database name}

\item{protect}{Parameters to be hidden}

\item{...}{Optional, additional suitable parameters passed to \code{\link[DBI:dbConnect]{DBI::dbConnect()}}}
}
\value{
Invisible self
}
\description{
Setup database driver and define connection parameters for SQLite using \link[RSQLite:SQLite]{RSQLite} package.
Wrapper for setupDriver() function.
}
\examples{
db <- rocker::newDB()
rocker::setupSQLite(
  db,
  dbname = ":memory:"
)
rocker::unloadDriver(db)
}
\seealso{
Other rocker-S3-functions: 
\code{\link{appendTable}()},
\code{\link{begin}()},
\code{\link{canConnect}()},
\code{\link{clearResult}()},
\code{\link{columnInfo}()},
\code{\link{commit}()},
\code{\link{connect}()},
\code{\link{createTable}()},
\code{\link{disconnect}()},
\code{\link{execute}()},
\code{\link{existsTable}()},
\code{\link{fetch}()},
\code{\link{getInfoCon}()},
\code{\link{getInfoDrv}()},
\code{\link{getInfoRes}()},
\code{\link{getQuery}()},
\code{\link{getRowCount}()},
\code{\link{getRowsAffected}()},
\code{\link{getStatement}()},
\code{\link{hasCompleted}()},
\code{\link{isValidCon}()},
\code{\link{isValidDrv}()},
\code{\link{isValidRes}()},
\code{\link{listFields}()},
\code{\link{listObjects}()},
\code{\link{listTables}()},
\code{\link{readTable}()},
\code{\link{removeTable}()},
\code{\link{rocker-README}},
\code{\link{rocker-S3-functions}},
\code{\link{rocker-package}},
\code{\link{rollback}()},
\code{\link{sendQuery}()},
\code{\link{sendStatement}()},
\code{\link{setupDriver}()},
\code{\link{setupMariaDB}()},
\code{\link{setupPostgreSQL}()},
\code{\link{unloadDriver}()},
\code{\link{validateCon}()},
\code{\link{writeTable}()}
}
\concept{rocker-S3-functions}
