% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot_simple_heatmap}
\alias{plot_simple_heatmap}
\title{Plot heatmap}
\usage{
plot_simple_heatmap(environment, name, markers, path = NA,
  membership = NA, normalized = NA, order = NA, width = 5,
  height = 5, scale = "row", RowSideColors = NA, counts = F,
  filter.diff.exp = F, cellnote = F, key = F, save = NA,
  sort.rows = T, sort.cols = T, Colv = F, Rowv = F,
  dendrogram = "none", main = NA)
}
\arguments{
\item{environment}{The \code{environment} object}

\item{name}{The file name of the figure}

\item{markers}{The markers to be plotted}

\item{path}{The path where the plot is saved; by default in TMPDIR}

\item{membership}{The cluster membership}

\item{normalized}{The normalized data matrix}

\item{order}{The ordering of markers}

\item{width}{The width of the pdf figure}

\item{height}{The height of the pdf figure}

\item{scale}{character indicating if the values should be centered and
    scaled in either the row direction or the column direction, or
    none.  The default is \code{"none"}.}

\item{RowSideColors}{(optional) character vector of length
    \code{nrow(x)} containing the color names for a vertical side bar
    that may be used to annotate the rows of \code{x}.}

\item{counts}{Plot count matrix or not}

\item{filter.diff.exp}{Whether to filter for differentially expressed genes}

\item{cellnote}{(optional) matrix of character strings which will be
    placed within each color cell, e.g. p-value symbols.}

\item{key}{logical indicating whether a color-key should be shown.}

\item{save}{The path where the plot is saved}

\item{sort.rows}{Whether to sort rows}

\item{sort.cols}{Whether to sort columns}

\item{Colv}{determines if and how the \emph{column} dendrogram should
    be reordered.	Has the options as the \code{Rowv} argument above and
    \emph{additionally} when \code{x} is a square matrix,
    \code{Colv="Rowv"} means that columns should be treated identically
    to the rows.}

\item{Rowv}{determines if and how the \emph{row} dendrogram should be
    reordered.	By default, it is TRUE, which implies dendrogram is
    computed and reordered based on row means. If NULL or FALSE, then no
    dendrogram is computed and no reordering is done. If a
    \code{\link{dendrogram}}, then it is used "as-is", ie
    without any reordering. If a vector of integers, then dendrogram is
    computed and reordered based on the order of the vector.}

\item{dendrogram}{character string indicating whether to draw 'none',
    'row', 'column' or 'both' dendrograms.  Defaults to 'both'. However,
    if Rowv (or Colv) is FALSE or NULL and dendrogram is 'both', then a
    warning is issued and Rowv (or Colv) arguments are honoured.}

\item{main}{main, x- and y-axis titles; defaults to none.}
}
\description{
Plot heatmap given a set of markers.
}
