% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wobble.R
\name{wobble}
\alias{wobble}
\title{Add random noise to remove ties}
\usage{
wobble(x, y, check = TRUE)
}
\arguments{
\item{x}{a (non-empty) numeric vector of data values.}

\item{y}{a (non-empty) numeric vector of data values.}

\item{check}{a logical value indicating whether the samples should be checked
for bindings prior to adding uniform noise or not, defaults to
\code{TRUE}.}
}
\value{
A named list of length two containing the modified input samples \code{x} and
\code{y}.
}
\description{
\code{wobble} adds noise from a continuous uniform distribution to the
observations to remove ties.
}
\details{
If \code{check = TRUE} the function checks whether all values in the two numeric
input vectors are distinct. If so, it returns the original values, otherwise
the ties are removed by adding noise from a continuous uniform distribution
to all observations. If \code{check = FALSE}, it simply determines the number
of digits and adds uniform noise.

More precisely, we determine the minimum number of digits \code{d_min} in the sample
and then add random numbers from the U[-0.5 10^(-\code{d_min}), 0.5 10^(-\code{d_min})]
distribution to each of the observations.
}
\examples{
x <- rnorm(20); y <- rnorm(20); x <- round(x)
wobble(x, y)

}
\references{
\insertRef{FriGat07rank}{robnptests}
}
