% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{check_test_input}
\alias{check_test_input}
\title{Checks for input arguments}
\usage{
check_test_input(
  x,
  y,
  alternative,
  delta,
  method,
  scale,
  n.rep,
  na.rm,
  var.test,
  wobble,
  wobble.seed,
  gamma = NULL,
  psi = NULL,
  k = NULL,
  test.name
)
}
\arguments{
\item{x}{a (non-empty) numeric vector of data values.}

\item{y}{a (non-empty) numeric vector of data values.}

\item{alternative}{a character string specifying the alternative hypothesis,
must be one of "two.sided", "greater", or "less".}

\item{delta}{a numeric value indicating the true difference in the location
or scale parameter, depending on whether the test should be
performed for a difference in location or in scale.}

\item{scale}{a character string specifying the scale estimator used for
standardization in the test statistic; must be one of \code{"S1"},
\code{"S2"}, \code{"S3"}, and \code{"S4"}.}

\item{n.rep}{an integer value specifying the number of random splits used to
calculate the randomization distribution if \code{method = "randomization"}.}

\item{na.rm}{a logical value indicating whether NA values in \code{x} and \code{y}
should be stripped before the computation proceeds.}

\item{var.test}{a logical value testing whether the samples should be compared
for a difference in scale.}

\item{wobble}{a logical value indicating whether the sample should be checked
for duplicated values that can cause the scale estimate to be zero.
If such values are present, uniform noise is added to the sample,
see \code{\link[robnptests]{wobble}}.}

\item{wobble.seed}{an integer value used as a seed for the random number
generation in case of \code{wobble = TRUE} or when
\code{var.test = TRUE} with one of the vectors \code{x} and
\code{y} containing zeros. When no seed is specified, it
is chosen randomly and printed in a message. The argument
is ignored if \code{var.test = FALSE} and/or \code{wobble = FALSE}.}

\item{gamma}{a numeric value in [0, 0.5] specifying the fraction of observations
to be trimmed/replaced from each end of the sample before
trimmed mean/winsorized variance.}

\item{psi}{kernel used for optimization in the computation of the M-estimates.
Must be one of \code{"bisquare"}, \code{"hampel"} and
\code{"huber"}.}

\item{k}{tuning parameter(s) for the respective psi function.}

\item{test.name}{character string specifying the two-sample test for which
the helper function is used.}
}
\value{
An error message if a check fails.
}
\description{
\code{check_test_input} is a helper functions that contains checks for the
input arguments of the two-sample tests.
}
\details{
The two-sample tests in this package share similar arguments. To reduce the
amount of repetitive code, this function contains the argument checks so that
only \code{check_test_input} needs to be called within the functions for
the two-sample tests.

The scale estimators \code{"S1"} and \code{"S2"} can only be used in
combination with \code{test.name = "hl1_test"} or \code{test.name = "hl2_test"}.
The estimators \code{"S3"} and \code{"S4"} can only be used with
\code{test.name = "med_test"}.
}
\keyword{internal}
