% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test_mediation.R
\name{test_mediation}
\alias{test_mediation}
\alias{print.boot_test_mediation}
\alias{print.sobel_test_mediation}
\alias{test_mediation.default}
\alias{test_mediation.fit_mediation}
\alias{robmed}
\alias{indirect}
\title{(Robust) mediation analysis}
\usage{
test_mediation(data, ...)

\method{test_mediation}{default}(data, x, y, m, covariates = NULL,
  test = c("boot", "sobel"), alternative = c("twosided", "less",
  "greater"), R = 5000, level = 0.95, type = c("bca", "perc"),
  method = c("regression", "covariance"), robust = TRUE,
  median = FALSE, control, ...)

\method{test_mediation}{fit_mediation}(data, test = c("boot", "sobel"),
  alternative = c("twosided", "less", "greater"), R = 5000,
  level = 0.95, type = c("bca", "perc"), ...)

robmed(..., test = "boot", method = "regression", robust = TRUE,
  median = FALSE)

indirect(..., test = "boot", method = "regression", robust = FALSE,
  median = FALSE)
}
\arguments{
\item{data}{a data frame containing the variables.  Alternatively, this can
be a mediation model fit as returned by \code{\link{fit_mediation}}.}

\item{\dots}{additional arguments to be passed down.  For the bootstrap
tests, those can be used to specify arguments of \code{\link[boot]{boot}},
for example for parallel computing.}

\item{x}{a character string, an integer or a logical vector specifying the
column of \code{data} containing the independent variable.}

\item{y}{a character string, an integer or a logical vector specifying the
column of \code{data} containing the dependent variable.}

\item{m}{a character, integer or logical vector specifying the columns of
\code{data} containing the hypothesized mediator variables.}

\item{covariates}{optional; a character, integer or logical vector
specifying the columns of \code{data} containing additional covariates to be
used as control variables.}

\item{test}{a character string specifying the test to be performed for
the indirect effect.  Possible values are \code{"boot"} (the default) for
the bootstrap, or \code{"sobel"} for Sobel's test.  Currently, Sobel's test
is not implemented for more than one hypothesized mediator variable.}

\item{alternative}{a character string specifying the alternative hypothesis
in the test for the indirect effects.  Possible values are \code{"twosided"}
(the default), \code{"less"} or \code{"greater"}.}

\item{R}{an integer giving the number of bootstrap replicates.  The default
is to use 5000 bootstrap replicates.}

\item{level}{numeric; the confidence level of the confidence interval in
the bootstrap test.  The default is to compute a 95\% confidence interval.}

\item{type}{a character string specifying the type of confidence interval
to be computed in the bootstrap test.  Possible values are \code{"bca"} (the
default) for the bias-corrected and accelerated bootstrap, or \code{"perc"}
for the percentile bootstrap.}

\item{method}{a character string specifying the method of estimation for
the mediation model.  Possible values are \code{"regression"} (the default)
to estimate the effects via regressions, or \code{"covariance"} to estimate
the effects via the covariance matrix.  Note that the effects are
always estimated via regressions if more than one hypothesized mediator is
supplied in \code{m}, or if control variables are specified via
\code{covariates}.}

\item{robust}{a logical indicating whether to perform a robust test
(defaults to \code{TRUE}).}

\item{median}{a logical indicating if the effects should be estimated via
median regression (defaults to \code{FALSE}).  This is ignored unless
\code{method} is \code{"regression"} and \code{robust} is \code{TRUE}.}

\item{control}{a list of tuning parameters for the corresponding robust
method.  For robust regression (\code{method = "regression"},
\code{robust = TRUE} and \code{median = FALSE}), a list of tuning
parameters for \code{\link[robustbase]{lmrob}} as generated by
\code{\link{reg_control}}.  For Huberized covariance matrix estimation
(\code{method = "covariance"} and \code{robust = TRUE}), a list of tuning
parameters for \code{\link{cov_Huber}} as generated by
\code{\link{cov_control}}.  No tuning parameters are necessary for median
regression (\code{method = "regression"}, \code{robust = TRUE} and
\code{median = TRUE}).}
}
\value{
An object inheriting from class \code{"test_mediation"} (class
\code{"boot_test_mediation"} if \code{test} is \code{"boot"} or
\code{"sobel_test_mediation"} if \code{test} is \code{"sobel"}) with the
following components:
\item{ab}{a numeric vector containing the point estimates of the indirect
effects.}
\item{ci}{a numeric vector of length two or a matrix of two columns
containing the bootstrap confidence intervals for the indirect effects
(only \code{"boot_test_mediation"}).}
\item{reps}{an object of class \code{"\link[boot]{boot}"} containing
the bootstrap replicates of the effects (only \code{"boot_test_mediation"}).}
\item{se}{numeric; the standard error of the indirect effect according
to Sobel's formula (only \code{"sobel_test_mediation"}).}
\item{statistic}{numeric; the test statistic for Sobel's test (only
\code{"sobel_test_mediation"}).}
\item{p_value}{numeric; the p-value from Sobel's test (only
\code{"sobel_test_mediation"}).}
\item{alternative}{a character string specifying the alternative
hypothesis in the test for the indirect effects.}
\item{R}{an integer giving the number of bootstrap replicates (only
\code{"boot_test_mediation"}).}
\item{level}{numeric; the confidence level of the bootstrap confidence
interval (only \code{"boot_test_mediation"}).}
\item{type}{a character string specifying the type of bootstrap
confidence interval (only \code{"boot_test_mediation"}).}
\item{fit}{an object inheriting from class
\code{"\link{fit_mediation}"} containing the estimation results for the
direct effect and the total effect in the mediation model.}
}
\description{
Perform (robust) mediation analysis via a (fast and robust) bootstrap test
or Sobel's test.
}
\details{
If \code{method} is \code{"regression"}, \code{robust} is \code{TRUE} and
\code{median} is \code{FALSE} (the defaults), the tests are based on robust
regressions with \code{\link[robustbase]{lmrob}}.  The bootstrap test is
thereby performed via the fast and robust bootstrap.

Note that the regression estimator implemented in
\code{\link[robustbase]{lmrob}} can be seen as weighted least squares
estimator, where the weights are dependent on how much an observation is
deviating from the rest.  The trick for the fast and robust bootstrap is
that on each bootstrap sample, first a weighted least squares estimator
is computed (using those robustness weights from the original sample)
followed by a linear correction of the coefficients.  The purpose of this
correction is to account for the additional uncertainty of obtaining the
robustness weights.

If \code{method} is \code{"regression"}, \code{robust} is \code{TRUE} and
\code{median} is \code{TRUE}, the tests are based on median regressions with
\code{\link[quantreg]{rq}} and the standard bootstrap ().  Unlike the robust
regressions described above, median regressions are not robust against
outliers in the explanatory variables, and the standard bootstrap can suffer
from oversampling of outliers in the bootstrap samples.

If \code{method} is \code{"covariance"} and \code{robust} is \code{TRUE},
the tests are based on a Huber M-estimator of location and scatter.  For the
bootstrap test, the M-estimates are used to first clean the data via a
transformation.  Then the standard bootstrap is performed with the cleaned
data.  Note that this covariance-based approach is less robust than the
approach based on robust regressions described above.  Furthermore, the
bootstrap does not account for the variability from cleaning the data.

\code{robmed} is a wrapper function for performing robust mediation analysis
via regressions and the fast and robust bootstrap.

\code{indirect} is a wrapper function for performing non-robust mediation
analysis via regressions and the bootstrap (inspired by Preacher & Hayes'
\code{SPSS} macro \code{INDIRECT}).
}
\note{
For the fast and robust bootstrap, the simpler correction of
Salibian-Barrera & Van Aelst (2008) is used rather than the originally
proposed correction of Salibian-Barrera & Zamar (2002).
}
\examples{
data("BSG2014")
test <- test_mediation(BSG2014,
                       x = "ValueDiversity",
                       y = "TeamCommitment",
                       m = "TaskConflict")
summary(test)

}
\references{
Alfons, A., Ates, N.Y. and Groenen, P.J.F. (2018) A robust bootstrap test
for mediation analysis.  \emph{ERIM Report Series in Management}, Erasmus
Research Institute of Management.  URL
\url{https://hdl.handle.net/1765/109594}.

Preacher, K.J. and Hayes, A.F. (2004) SPSS and SAS procedures for estimating
indirect effects in simple mediation models. \emph{Behavior Research Methods,
Instruments, & Computers}, \bold{36}(4), 717--731.

Preacher, K.J. and Hayes, A.F. (2008) Asymptotic and resampling strategies
for assessing and comparing indirect effects in multiple mediator models.
\emph{Behavior Research Methods}, \bold{40}(3), 879--891.

Salibian-Barrera, M. and Van Aelst, S. (2008) Robust model selection using
fast and robust bootstrap. \emph{Computational Statistics & Data Analysis},
\bold{52}(12), 5121--5135

Salibian-Barrera, M. and Zamar, R. (2002) Bootstrapping robust estimates of
regression. \emph{The Annals of Statistics}, \bold{30}(2), 556--582.

Sobel, M.E. (1982) Asymptotic confidence intervals for indirect effects in
structural equation models. \emph{Sociological Methodology}, \bold{13},
290--312.

Yuan, Y. and MacKinnon, D.P. (2014) Robust mediation analysis based on
median regression. \emph{Psychological Methods}, \bold{19}(1),
1--20.

Zu, J. and Yuan, K.-H. (2010) Local influence and robust procedures for
mediation analysis. \emph{Multivariate Behavioral Research}, \bold{45}(1),
1--44.
}
\seealso{
\code{\link{fit_mediation}}

\code{\link[=coef.test_mediation]{coef}},
\code{\link[=confint.test_mediation]{confint}},
\code{\link[=fortify.test_mediation]{fortify}} and
\code{\link[=plot_mediation]{plot}} methods, \code{\link{p_value}}

\code{\link[boot]{boot}}, \code{\link[robustbase]{lmrob}},
\code{\link[stats]{lm}}, \code{\link{cov_Huber}}, \code{\link{cov_ML}}
}
\author{
Andreas Alfons
}
\keyword{multivariate}
