% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/biomarker.R
\name{biomarker}
\alias{biomarker}
\alias{print.biomarker}
\alias{summary.biomarker}
\alias{plot.biomarker}
\alias{print.biomarker}
\alias{summary.biomarker}
\title{biomarker}
\usage{
biomarker(x, cut = qnorm(0.975, 0, 1), g1, g2, type = "tau", diag = TRUE,
  plot = FALSE, diag.plot = FALSE)

\method{plot}{biomarker}(x, cut = qnorm(0.975, 0, 1), type = "Vstar", ...)

\method{print}{biomarker}(x, ...)

\method{summary}{biomarker}(object, ...)
}
\arguments{
\item{x}{data frame}

\item{cut}{cut-off value, initialy set as 0.975 quantile of standard normal distribution}

\item{g1}{vector with locations of observations of group 1}

\item{g2}{vector with locations of observations of group 2}

\item{type}{type of estimation of the variation matrix. Possible values are \code{"sd"},  \code{"mad"} and \code{"tau"}, representing Standard deviation, Median absolute deviation and Tau estimator of scale}

\item{diag}{logical, indicating wheter outlier diagnostic should be computed}

\item{plot}{logical, indicating wheter Vstar values should be plotted}

\item{diag.plot}{logical, indicating wheter outlier diagnostic plot should be made}

\item{...}{further arguments can be passed through}

\item{object}{object of class biomarker}
}
\value{
The function returns object of type "biomarker".
Functions \code{print}, \code{plot} and \code{summary} are available.
\item{biom.ident}{List of \code{V, Vstar, biomarkers}}
\item{V}{Values of \emph{V} statistics}
\item{Vstar}{Normalizes values of \emph{V} statistics (V^* values))}
\item{biomarkers}{Logical value, indicating if certain variable was identified as biomarker}
\item{diag}{Outlier diagnostics (returned only if \code{diag=TRUE})}
}
\description{
The function for identification of biomakers and 
outlier diagnostics as described in paper "Robust biomarker 
identification in a two-class problem based on pairwise log-ratios"
}
\details{
Robust biomarker identification and outlier diagnostics

The method computes variation matrices separately with 
observations from both groups and also together with all observations. 
Then, \emph{V} statistics is then computed and normalized. 
The variables, for which according \emph{V*} values are bigger that the 
cut-off value are considered as biomarkers.
}
\examples{
# Data simulation
set.seed(4523)
n <- 40; p <- 50
r <- runif(p, min = 1, max = 10)
conc <- runif(p, min = 0, max = 1)*5+matrix(1,p,1)*5
a <- conc*r
S <- rnorm(n,0,0.3) \%*\% t(rep(1,p))
B <- matrix(rnorm(n*p,0,0.8),n,p)
R <- rep(1,n) \%*\% t(r)
M <- matrix(rnorm(n*p,0,0.021),n,p)
# Fifth observation is an outlier
M[5,] <- M[5,]*3 + sample(c(0.5,-0.5),replace=TRUE,p)
C <- rep(1,n) \%*\% t(conc)
C[1:20,c(2,15,28,40)] <- C[1:20,c(2,15,28,40)]+matrix(1,20,4)*1.8
X <- (1-S)*(C*R+B)*exp(M)
# Biomarker identification
b <- biomarker(X, g1 = 1:20, g2 = 21:40, type = "tau")
}
\seealso{
\link{plot.biomarker}
}
\author{
Jan Walach

Jan Walach
}
