% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/orthbasis.R
\name{orthbasis}
\alias{orthbasis}
\title{Orthonormal basis}
\usage{
orthbasis(D)
}
\arguments{
\item{D}{number of parts (variables)}
}
\value{
the orthonormal basis.
}
\description{
Orthonormal basis from cenLR transformed data to isomLR transformated data.
}
\details{
For the chosen balances for \dQuote{isomLR}, this is the orthonormal basis
that transfers the data from centered logratio to isometric logratio.
}
\examples{

data(expenditures)
V <- orthbasis(ncol(expenditures))
xcen <- cenLR(expenditures)$x.clr
xi <- as.matrix(xcen) \%*\% V
xi2 <- isomLR(expenditures)
all.equal(xi, xi2)

}
\author{
Karel Hron, Matthias Templ
}
\seealso{
\code{\link{isomLR}}, \code{\link{cenLR}}
}
\keyword{manip}

