% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rnoaa_caching.R
\docType{data}
\name{rnoaa_caching}
\alias{rnoaa_caching}
\alias{isd_cache}
\alias{cpc_cache}
\alias{arc2_cache}
\alias{lcd_cache}
\alias{bsw_cache}
\alias{storms_cache}
\alias{ersst_cache}
\alias{torn_cache}
\alias{ghcnd_cache}
\title{rnoaa caching}
\description{
Manage data caches
}
\details{
To get the cache directory for a data source, see the method
\code{x$cache_path_get()}

\code{cache_delete} only accepts 1 file name, while
\code{cache_delete_all} doesn't accept any names, but deletes all files.
For deleting many specific files, use \code{cache_delete} in a \code{\link[=lapply]{lapply()}}
type call

Note that cached files will continue to be used until they are deleted.
It's possible to run into problems when changes happen in your R
setup. For example, at least one user reported changing versions
of this package and running into problems because a cached data
file from a previous version of rnoaa did not work with the newer
version of rnoaa. You should occassionally delete all cached files.
}
\section{Useful user functions}{


Assuming x is a \code{HoardClient} class object, e.g., \code{lcd_cache}
\itemize{
\item \code{x$cache_path_get()} get cache path
\item \code{x$cache_path_set()} set cache path
\item \code{x$list()} returns a character vector of full path file names
\item \code{x$files()} returns file objects with metadata
\item \code{x$details()} returns files with details
\item \code{x$delete()} delete specific files
\item \code{x$delete_all()} delete all files, returns nothing
}
}

\section{Caching objects for each data source}{

\itemize{
\item \code{isd()}/\code{isd_stations()}: \code{isd_cache}
\item \code{cpc_prcp()}: \code{cpc_cache}
\item \code{arc2()}: \code{arc2_cache}
\item \code{lcd()}: \code{lcd_cache}
\item \code{bsw()}: \code{bsw_cache}
\item \code{storm_data()}: \code{storms_cache}
\item \code{ersst()}: \code{ersst_cache}
\item \code{tornadoes()}: \code{torn_cache}
\item \code{ghcnd()}/\code{ghcnd_search()}: \code{ghcnd_cache}
}
}

\seealso{
\code{\link[=rnoaa_options]{rnoaa_options()}} for managing whether you see messages
about cached files when you request data
}
\keyword{datasets}
