% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meteo_distance.R
\name{meteo_spherical_distance}
\alias{meteo_spherical_distance}
\title{Calculate the distance between two locations}
\usage{
meteo_spherical_distance(lat1, long1, lat2, long2, units = "deg")
}
\arguments{
\item{lat1}{Latitude of the first location.}

\item{long1}{Longitude of the first location.}

\item{lat2}{Latitude of the second location.}

\item{long2}{Longitude of the second location.}

\item{units}{Units of the latitude and longitude values. Possible values
are:
\itemize{
\item \code{deg}: Degrees (default);
\item \code{rad}: Radians.
}}
}
\value{
A numeric value giving the distance (in kilometers) between the
   pair of locations.
}
\description{
This function uses the haversine formula to calculate the great circle
distance between two locations, identified by their latitudes and longitudes.
}
\note{
This function assumes an earth radius of 6,371 km.
}
\examples{

meteo_spherical_distance(lat1 = -27.4667, long1 = 153.0217,
                         lat2 = -27.4710, long2 = 153.0234)
}
\author{
Alex Simmons \email{a2.simmons@qut.edu.au},
   Brooke Anderson \email{brooke.anderson@colostate.edu}
}

