% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/ncdc.r
\name{ncdc}
\alias{ncdc}
\title{Search for and get NOAA NCDC data.}
\usage{
ncdc(datasetid = NULL, datatypeid = NULL, stationid = NULL,
  locationid = NULL, startdate = NULL, enddate = NULL, sortfield = NULL,
  sortorder = NULL, limit = 25, offset = NULL, token = NULL,
  dataset = NULL, datatype = NULL, station = NULL, location = NULL,
  locationtype = NULL, page = NULL, year = NULL, month = NULL,
  day = NULL, includemetadata = TRUE, results = NULL, ...)
}
\arguments{
\item{datasetid}{(required) Accepts a single valid dataset id. Data returned will be from the
dataset specified, see datasets()}

\item{datatypeid}{Accepts a valid data type id or a chain of data type ids in a
   comma-separated vector. Data returned will contain all of the data type(s) specified
(optional)}

\item{stationid}{Accepts a valid station id or a chain of of station ids in a
comma-separated vector. Data returned will contain data for the station(s) specified (optional)}

\item{locationid}{Accepts a valid location id or a chain of location ids in a
comma-separated vector. Data returned will contain data for the location(s) specified (optional)}

\item{startdate}{(required) Accepts valid ISO formated date (yyyy-mm-dd) or date time
(YYYY-MM-DDThh:mm:ss). Data returned will have data after the specified date. The
date range must be less than 1 year.}

\item{enddate}{(required) Accepts valid ISO formated date (yyyy-mm-dd) or date time
(YYYY-MM-DDThh:mm:ss). Data returned will have data before the specified date. The
date range must be less than 1 year.}

\item{sortfield}{The field to sort results by. Supports id, name, mindate, maxdate, and
datacoverage fields (optional)}

\item{sortorder}{Which order to sort by, asc or desc. Defaults to asc (optional)}

\item{limit}{Defaults to 25, limits the number of results in the response. Maximum is
1000 (optional)}

\item{offset}{Defaults to 0, used to offset the resultlist (optional)}

\item{token}{This must be a valid token token supplied to you by NCDC's Climate
Data Online access token generator. (required) Get an API key (=token) at
http://www.ncdc.noaa.gov/cdo-web/token. You can pass your token in as
an argument or store it in your .Rprofile file with an entry like
\itemize{
  \item options("noaakey" = "your-noaa-token")
}}

\item{dataset}{THIS IS A DEPRECATED ARGUMENT. See datasetid.}

\item{datatype}{THIS IS A DEPRECATED ARGUMENT. See datatypeid.}

\item{station}{THIS IS A DEPRECATED ARGUMENT. See stationid.}

\item{location}{THIS IS A DEPRECATED ARGUMENT. See locationid.}

\item{locationtype}{THIS IS A DEPRECATED ARGUMENT. There is no equivalent argument in v2
of the NOAA API.}

\item{page}{THIS IS A DEPRECATED ARGUMENT. There is no equivalent argument in v2
of the NOAA API.}

\item{year}{THIS IS A DEPRECATED ARGUMENT. Use combination of startdate and enddate
arguments.}

\item{month}{THIS IS A DEPRECATED ARGUMENT. Use combination of startdate and enddate
arguments.}

\item{day}{THIS IS A DEPRECATED ARGUMENT. Use combination of startdate and enddate
arguments.}

\item{includemetadata}{Used to improve response time by preventing the calculation of
result metadata. Default: TRUE. This does not affect the return object, in that the named part
of the output list called "meta' is still returned, but is NULL. In practice, I haven't seen
response time's improve, but perhaps they will for you.}

\item{results}{THIS IS A DEPRECATED ARGUMENT. See limit.}

\item{...}{Curl options passed on to \code{\link[httr]{GET}} (optional)}
}
\value{
An S3 list of length two, a slot of metadata (meta), and a slot for data (data).
The meta slot is a list of metadata elements, and the data slot is a data.frame,
possibly of length zero if no data is found.
}
\description{
Search for and get NOAA NCDC data.
}
\details{
Note that NOAA NCDC API calls can take a long time depending on the call. The NOAA API doesn't
perform well with very long timespans, and will time out and make you angry - beware.

Keep in mind that three parameters, datasetid, startdate, and enddate are required.

Note that the default limit (no. records returned) is 25. Look at the metadata in \code{$meta}
to see how many records were found. If more were found than 25, you could set the parameter
\code{limit} to something higher than 25.

The attributes, or "flags", for each row of the output for data may have a flag
with it. Each \code{datasetid} has it's own set of flags. The following are flag
columns, and what they stand for. \code{fl_} is the beginning of each flag
column name, then one or more characters to describe the flag, keeping it short
to maintain a compact data frame. Some of these fields are the same across
datasetids. See the vignette \code{vignette("rnoaa_attributes", "rnoaa")} for
description of possible values for each flag.

\itemize{
 \item fl_c completeness
 \item fl_d day
 \item fl_m measurement
 \item fl_q quality
 \item fl_s source
 \item fl_t time
 \item fl_cmiss consecutive missing
 \item fl_miss missing
 \item fl_u units
}
}
\examples{
\dontrun{
# GHCN-Daily (or GHCND) data, for a specific station
ncdc(datasetid='GHCND', stationid='GHCND:USW00014895', startdate = '2013-10-01',
   enddate = '2013-12-01')

# GHCND data, for a location by FIPS code
ncdc(datasetid='GHCND', locationid = 'FIPS:02', startdate = '2010-05-01',
   enddate = '2010-05-10')

# GHCND data from October 1 2013 to December 1 2013
ncdc(datasetid='GHCND', startdate = '2013-10-01', enddate = '2013-10-05')

# GHCN-Monthly (or GHCNDMS) data from October 1 2013 to December 1 2013
ncdc(datasetid='GHCNDMS', startdate = '2013-10-01', enddate = '2013-12-01')

# Normals Daily (or NORMAL_DLY) GHCND:USW00014895 dly-tmax-normal data
ncdc(datasetid='NORMAL_DLY', stationid='GHCND:USW00014895', startdate = '2010-05-01',
   enddate = '2010-05-10')

# Dataset, and location in Australia
ncdc(datasetid='GHCND', locationid='FIPS:AS', startdate = '2010-05-01', enddate = '2010-05-31')

# Dataset, location and datatype for PRECIP_HLY data
ncdc(datasetid='PRECIP_HLY', locationid='ZIP:28801', datatypeid='HPCP',
   startdate = '2010-05-01', enddate = '2010-05-10')

# Dataset, location, station and datatype
ncdc(datasetid='PRECIP_HLY', locationid='ZIP:28801', stationid='COOP:310301', datatypeid='HPCP',
   startdate = '2010-05-01', enddate = '2010-05-10')

# Dataset, location, and datatype for GHCND
ncdc(datasetid='GHCND', locationid='FIPS:BR', datatypeid='PRCP', startdate = '2010-05-01',
   enddate = '2010-05-10')

# Normals Daily GHCND dly-tmax-normal data
ncdc(datasetid='NORMAL_DLY', datatypeid='dly-tmax-normal', startdate = '2010-05-01',
   enddate = '2010-05-10')

# Normals Daily GHCND:USW00014895 dly-tmax-normal
ncdc(datasetid='NORMAL_DLY', stationid='GHCND:USW00014895', datatypeid='dly-tmax-normal',
   startdate = '2010-05-01', enddate = '2010-05-10')

# Hourly Precipitation data for ZIP code 28801
ncdc(datasetid='PRECIP_HLY', locationid='ZIP:28801', datatypeid='HPCP',
   startdate = '2010-05-01', enddate = '2010-05-10')

# 15 min Precipitation data for ZIP code 28801
ncdc(datasetid='PRECIP_15', datatypeid='QPCP', startdate = '2010-05-01', enddate = '2010-05-02')

# Search the NORMAL_HLY dataset
ncdc(datasetid='NORMAL_HLY', stationid = 'GHCND:USW00003812', startdate = '2010-05-01',
   enddate = '2010-05-10')

# Search the ANNUAL dataset
ncdc(datasetid='ANNUAL', locationid='ZIP:28801', startdate = '2010-05-01',
   enddate = '2010-05-10')

# Search the NORMAL_ANN dataset
ncdc(datasetid='NORMAL_ANN', datatypeid='ANN-DUTR-NORMAL', startdate = '2010-01-01',
   enddate = '2010-01-01')

# Include metadata or not
ncdc(datasetid='GHCND', stationid='GHCND:USW00014895', startdate = '2013-10-01',
   enddate = '2013-12-01')
ncdc(datasetid='GHCND', stationid='GHCND:USW00014895', startdate = '2013-10-01',
   enddate = '2013-12-01', includemetadata=FALSE)
}

\dontrun{
# NEXRAD2 data
## doesn't work yet
ncdc(datasetid='NEXRAD2', startdate = '2013-10-01', enddate = '2013-12-01')
}
}

