% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/endpoint_rates.R
\name{get_current_exchangerate}
\alias{get_current_exchangerate}
\title{Retrieves the current exchange rate for the given currency.}
\usage{
get_current_exchangerate(table, currency_code)
}
\arguments{
\item{table}{specifies which from which table the exchange
rate should be fetched.}

\item{currency_code}{code of the currency for which the
exchange rate should be fetched.}
}
\value{
nbp_api_response object containing the current
exchange rate.
}
\description{
Retrieves the current exchange rate for the given currency.
}
\examples{

\donttest{
## Retrieve the current exchange rate for euros
response <- get_current_exchangerate("A", "EUR")

## Retrieve the content
response$content

}

}
\seealso{
\url{http://api.nbp.pl/#kursyWalut}

Other rates: \code{\link{get_exchangerate_from_interval}},
  \code{\link{get_exchangerate_from}},
  \code{\link{get_last_n_exchangerates}},
  \code{\link{get_todays_exchangerate}}
}
\concept{rates}
