% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrappers.R
\name{nassqs_acres}
\alias{nassqs_acres}
\title{Get NASS Area given a set of parameters.}
\usage{
nassqs_acres(..., area = c("AREA", "AREA PLANTED", "AREA BEARING",
  "AREA BEARING & NON-BEARING", "AREA GROWN", "AREA HARVESTED",
  "AREA IRRIGATED", "AREA NON-BEARING", "AREA PLANTED",
  "AREA PLANTED, NET"))
}
\arguments{
\item{...}{either a named list of parameters or a series of parameters to
form the query}

\item{area}{the type of area to return. Default is all types.}
}
\value{
a data.frame of acres data
}
\description{
Get NASS Area given a set of parameters.
}
\examples{
\donttest{
  # Get Area bearing for Apples in Washington, 2012.
  params <- list(
    commodity_desc = "APPLES",
    year = "2012",
    state_name = "WASHINGTON",
    agg_level_desc = "STATE"
  )
  area <- nassqs_area(params, area = "AREA BEARING")
  head(area)
}
}
