% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stanMisc.r
\name{vcov.rmsb}
\alias{vcov.rmsb}
\title{Variance-Covariance Matrix}
\usage{
\method{vcov}{rmsb}(object, regcoef.only = TRUE, intercepts = "all", ...)
}
\arguments{
\item{object}{an object produced by an \code{rms} package Bayesian fitting function}

\item{regcoef.only}{set to \code{FALSE} to also include non-regression coefficients such as shape/scale parameters}

\item{intercepts}{set to \code{'all'} to include all intercepts (the default), \code{'none'} to exclude them all, or a vector of integers to get selected intercepts}

\item{...}{ignored}
}
\value{
matrix
}
\description{
Computes the variance-covariance matrix from the posterior draws by compute the sample covariance matrix of the draws
}
\examples{
\dontrun{
  f <- blrm(...)
  v <- vcov(f)
}
}
\seealso{
\link{vcov.rms}
}
\author{
Frank Harrell
}
