% Generated by roxygen2 (4.0.2): do not edit by hand
\name{mongo.bson.from.list}
\alias{mongo.bson.from.list}
\title{Convert a list to a mongo.bson object}
\usage{
mongo.bson.from.list(lst)
}
\arguments{
\item{lst}{(list) The list to convert.

This \emph{must} be a list, \emph{not} a vector of atomic types; otherwise,
an error is thrown; use \code{as.list()} as necessary.}
}
\value{
(\link{mongo.bson}) A mongo.bson object serialized from \code{lst}.
}
\description{
Convert a list to a \link{mongo.bson} object.
}
\details{
This function permits the simple and convenient creation of a mongo.bson
object. This bypasses the creation of a \link{mongo.bson.buffer}, appending
fields one by one, and then turning the buffer into a mongo.bson object with
\code{\link{mongo.bson.from.buffer}()}.

Note that this function and \code{\link{mongo.bson.to.list}()} perform inverse conversions.
}
\note{
Function converts unnamed R lists into bson arrays.
It is very easy to construct bson object of any form using this function and list.
}
\examples{
lst <- list(name="John", age=32)
b <- mongo.bson.from.list(lst)
# the above produces a BSON object of the form:
# { "name" : "John", "age" : 32.0 }

# Convert a vector of an atomic type to a list and
# then to a mongo.bson object
v <- c(president="Jefferson", vice="Burr")
b <- mongo.bson.from.list(as.list(v))
# the above produces a BSON object of the form:
# { "president" : "Jefferson", "vice" : "Burr" }
# Let's try to construct bson with array.
# This one
mongo.bson.from.list(list(fruits = list('apple', 'banana', 'orange')))
# will produce a BSON object of the form:
# {"fruits" : ["apple", "banana", "orange"]}
}
\seealso{
\code{\link{mongo.bson.to.list}},\cr \link{mongo.bson},\cr
\code{\link{mongo.bson.destroy}}.
}

