% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nearest_neighbors.R
\name{nearest_neighbors}
\alias{nearest_neighbors}
\title{Compute Nearest Neighbors}
\usage{
nearest_neighbors(data, k)
}
\arguments{
\item{data}{Matrix of sample observations, each row is an observation.}

\item{k}{Neighborhood order.}
}
\value{
List of distances and indices of the k-nearest neighbors of each point in \code{data}.
}
\description{
Computes the nearest neighbor distances and indices of a sample using the infinite norm.
}
\details{
Nearest neighbors are computed using the brute-force method.
}
\examples{
X <- cbind(1:10)
nearest_neighbors(X,3)

set.seed(123)
X <- cbind(runif(100),runif(100))
plot(X,pch=20)
points(X[3,1],X[3,2],col='blue',pch=19, cex=1.5)
nn <- nearest_neighbors(X,5)
a = X[nn$nn_inds[3,-1],1]
b = X[nn$nn_inds[3,-1],2]
points(a,b,col='red',pch=19, cex=1.5)
}
