/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.trees;

import java.util.Arrays;
import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;
import weka.classifiers.Evaluation;
import weka.classifiers.RandomizableClassifier;
import weka.core.AdditionalMeasureProducer;
import weka.core.Attribute;
import weka.core.Capabilities;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.RevisionUtils;
import weka.core.SelectedTag;
import weka.core.Tag;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.Utils;
import weka.core.matrix.EigenvalueDecomposition;
import weka.core.matrix.Matrix;

public class BFTree
extends RandomizableClassifier
implements AdditionalMeasureProducer,
TechnicalInformationHandler {
    private static final long serialVersionUID = -7035607375962528217L;
    public static final int PRUNING_UNPRUNED = 0;
    public static final int PRUNING_POSTPRUNING = 1;
    public static final int PRUNING_PREPRUNING = 2;
    public static final Tag[] TAGS_PRUNING = new Tag[]{new Tag(0, "unpruned", "Un-pruned"), new Tag(1, "postpruned", "Post-pruning"), new Tag(2, "prepruned", "Pre-pruning")};
    protected int m_PruningStrategy = 1;
    protected BFTree[] m_Successors;
    protected Attribute m_Attribute;
    protected double m_SplitValue;
    protected String m_SplitString;
    protected double m_ClassValue;
    protected Attribute m_ClassAttribute;
    protected int m_minNumObj = 2;
    protected int m_numFoldsPruning = 5;
    protected boolean m_isLeaf;
    protected static int m_Expansion;
    protected int m_FixedExpansion = -1;
    protected boolean m_Heuristic = true;
    protected boolean m_UseGini = true;
    protected boolean m_UseErrorRate = true;
    protected boolean m_UseOneSE = false;
    protected double[] m_Distribution;
    protected double[] m_Props;
    protected int[][] m_SortedIndices;
    protected double[][] m_Weights;
    protected double[][][] m_Dists;
    protected double[] m_ClassProbs;
    protected double m_TotalWeight;
    protected double m_SizePer = 1.0;

    public String globalInfo() {
        return "Class for building a best-first decision tree classifier. This class uses binary split for both nominal and numeric attributes. For missing values, the method of 'fractional' instances is used.\n\nFor more information, see:\n\n" + this.getTechnicalInformation().toString();
    }

    @Override
    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.MASTERSTHESIS);
        result.setValue(TechnicalInformation.Field.AUTHOR, "Haijian Shi");
        result.setValue(TechnicalInformation.Field.YEAR, "2007");
        result.setValue(TechnicalInformation.Field.TITLE, "Best-first decision tree learning");
        result.setValue(TechnicalInformation.Field.SCHOOL, "University of Waikato");
        result.setValue(TechnicalInformation.Field.ADDRESS, "Hamilton, NZ");
        result.setValue(TechnicalInformation.Field.NOTE, "COMP594");
        TechnicalInformation additional = result.add(TechnicalInformation.Type.ARTICLE);
        additional.setValue(TechnicalInformation.Field.AUTHOR, "Jerome Friedman and Trevor Hastie and Robert Tibshirani");
        additional.setValue(TechnicalInformation.Field.YEAR, "2000");
        additional.setValue(TechnicalInformation.Field.TITLE, "Additive logistic regression : A statistical view of boosting");
        additional.setValue(TechnicalInformation.Field.JOURNAL, "Annals of statistics");
        additional.setValue(TechnicalInformation.Field.VOLUME, "28");
        additional.setValue(TechnicalInformation.Field.NUMBER, "2");
        additional.setValue(TechnicalInformation.Field.PAGES, "337-407");
        additional.setValue(TechnicalInformation.Field.ISSN, "0090-5364");
        return result;
    }

    @Override
    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.disableAll();
        result.enable(Capabilities.Capability.NOMINAL_ATTRIBUTES);
        result.enable(Capabilities.Capability.NUMERIC_ATTRIBUTES);
        result.enable(Capabilities.Capability.MISSING_VALUES);
        result.enable(Capabilities.Capability.NOMINAL_CLASS);
        return result;
    }

    @Override
    public void buildClassifier(Instances data) throws Exception {
        this.getCapabilities().testWithFail(data);
        data = new Instances(data);
        data.deleteWithMissingClass();
        if (this.m_PruningStrategy == 0) {
            int[][] sortedIndices = new int[data.numAttributes()][0];
            double[][] weights = new double[data.numAttributes()][0];
            double[] classProbs = new double[data.numClasses()];
            double totalWeight = this.computeSortedInfo(data, sortedIndices, weights, classProbs);
            double[][][] dists = new double[data.numAttributes()][2][data.numClasses()];
            double[][] props = new double[data.numAttributes()][2];
            double[][] totalSubsetWeights = new double[data.numAttributes()][2];
            FastVector nodeInfo = this.computeSplitInfo(this, data, sortedIndices, weights, dists, props, totalSubsetWeights, this.m_Heuristic, this.m_UseGini);
            FastVector BestFirstElements = new FastVector();
            BestFirstElements.addElement(nodeInfo);
            int attIndex = ((Attribute)nodeInfo.elementAt(1)).index();
            m_Expansion = 0;
            this.makeTree(BestFirstElements, data, sortedIndices, weights, dists, classProbs, totalWeight, props[attIndex], this.m_minNumObj, this.m_Heuristic, this.m_UseGini, this.m_FixedExpansion);
            return;
        }
        int expansion = 0;
        Random random = new Random(this.m_Seed);
        Instances cvData = new Instances(data);
        cvData.randomize(random);
        cvData = new Instances(cvData, 0, (int)((double)cvData.numInstances() * this.m_SizePer) - 1);
        cvData.stratify(this.m_numFoldsPruning);
        Instances[] train = new Instances[this.m_numFoldsPruning];
        Instances[] test = new Instances[this.m_numFoldsPruning];
        FastVector[] parallelBFElements = new FastVector[this.m_numFoldsPruning];
        BFTree[] m_roots = new BFTree[this.m_numFoldsPruning];
        int[][][] sortedIndices = new int[this.m_numFoldsPruning][data.numAttributes()][0];
        double[][][] weights = new double[this.m_numFoldsPruning][data.numAttributes()][0];
        double[][] classProbs = new double[this.m_numFoldsPruning][data.numClasses()];
        double[] totalWeight = new double[this.m_numFoldsPruning];
        double[][][][] dists = new double[this.m_numFoldsPruning][data.numAttributes()][2][data.numClasses()];
        double[][][] props = new double[this.m_numFoldsPruning][data.numAttributes()][2];
        double[][][] totalSubsetWeights = new double[this.m_numFoldsPruning][data.numAttributes()][2];
        FastVector[] nodeInfo = new FastVector[this.m_numFoldsPruning];
        int i = 0;
        while (i < this.m_numFoldsPruning) {
            train[i] = cvData.trainCV(this.m_numFoldsPruning, i);
            test[i] = cvData.testCV(this.m_numFoldsPruning, i);
            parallelBFElements[i] = new FastVector();
            m_roots[i] = new BFTree();
            totalWeight[i] = this.computeSortedInfo(train[i], sortedIndices[i], weights[i], classProbs[i]);
            nodeInfo[i] = this.computeSplitInfo(m_roots[i], train[i], sortedIndices[i], weights[i], dists[i], props[i], totalSubsetWeights[i], this.m_Heuristic, this.m_UseGini);
            int attIndex = ((Attribute)nodeInfo[i].elementAt(1)).index();
            m_roots[i].m_SortedIndices = new int[sortedIndices[i].length][0];
            m_roots[i].m_Weights = new double[weights[i].length][0];
            m_roots[i].m_Dists = new double[dists[i].length][0][0];
            m_roots[i].m_ClassProbs = new double[classProbs[i].length];
            m_roots[i].m_Distribution = new double[classProbs[i].length];
            m_roots[i].m_Props = new double[2];
            int j = 0;
            while (j < m_roots[i].m_SortedIndices.length) {
                m_roots[i].m_SortedIndices[j] = sortedIndices[i][j];
                m_roots[i].m_Weights[j] = weights[i][j];
                m_roots[i].m_Dists[j] = dists[i][j];
                ++j;
            }
            System.arraycopy(classProbs[i], 0, m_roots[i].m_ClassProbs, 0, classProbs[i].length);
            if (Utils.sum(m_roots[i].m_ClassProbs) != 0.0) {
                Utils.normalize(m_roots[i].m_ClassProbs);
            }
            System.arraycopy(classProbs[i], 0, m_roots[i].m_Distribution, 0, classProbs[i].length);
            System.arraycopy(props[i][attIndex], 0, m_roots[i].m_Props, 0, props[i][attIndex].length);
            m_roots[i].m_TotalWeight = totalWeight[i];
            parallelBFElements[i].addElement(nodeInfo[i]);
            ++i;
        }
        if (this.m_PruningStrategy == 2) {
            double previousError;
            double currentError = previousError = Double.MAX_VALUE;
            double minError = Double.MAX_VALUE;
            int minExpansion = 0;
            FastVector errorList = new FastVector();
            while (true) {
                double expansionError = 0.0;
                int count = 0;
                int i2 = 0;
                while (i2 < this.m_numFoldsPruning) {
                    Evaluation eval;
                    if (expansion == 0) {
                        m_roots[i2].m_isLeaf = true;
                        eval = new Evaluation(test[i2]);
                        eval.evaluateModel(m_roots[i2], test[i2], new Object[0]);
                        expansionError = this.m_UseErrorRate ? (expansionError += eval.errorRate()) : (expansionError += eval.rootMeanSquaredError());
                        ++count;
                    } else if (m_roots[i2] != null) {
                        m_roots[i2].m_isLeaf = false;
                        BFTree nodeToSplit = (BFTree)((FastVector)parallelBFElements[i2].elementAt(0)).elementAt(0);
                        if (!m_roots[i2].makeTree(parallelBFElements[i2], m_roots[i2], train[i2], nodeToSplit.m_SortedIndices, nodeToSplit.m_Weights, nodeToSplit.m_Dists, nodeToSplit.m_ClassProbs, nodeToSplit.m_TotalWeight, nodeToSplit.m_Props, this.m_minNumObj, this.m_Heuristic, this.m_UseGini)) {
                            m_roots[i2] = null;
                        } else {
                            eval = new Evaluation(test[i2]);
                            eval.evaluateModel(m_roots[i2], test[i2], new Object[0]);
                            expansionError = this.m_UseErrorRate ? (expansionError += eval.errorRate()) : (expansionError += eval.rootMeanSquaredError());
                            ++count;
                        }
                    }
                    ++i2;
                }
                if (count == 0) break;
                errorList.addElement(new Double(expansionError /= (double)count));
                currentError = expansionError;
                if (!this.m_UseOneSE) {
                    if (currentError > previousError) {
                        break;
                    }
                } else {
                    double oneSE;
                    if (expansionError < minError) {
                        minError = expansionError;
                        minExpansion = expansion;
                    }
                    if (currentError > previousError && currentError > minError + (oneSE = Math.sqrt(minError * (1.0 - minError) / (double)data.numInstances()))) break;
                }
                ++expansion;
                previousError = currentError;
            }
            if (!this.m_UseOneSE) {
                --expansion;
            } else {
                double oneSE = Math.sqrt(minError * (1.0 - minError) / (double)data.numInstances());
                int i3 = 0;
                while (i3 < errorList.size()) {
                    double error = (Double)errorList.elementAt(i3);
                    if (error <= minError + oneSE) {
                        expansion = i3;
                        break;
                    }
                    ++i3;
                }
            }
        } else {
            FastVector[] modelError = new FastVector[this.m_numFoldsPruning];
            int i4 = 0;
            while (i4 < this.m_numFoldsPruning) {
                modelError[i4] = new FastVector();
                m_roots[i4].m_isLeaf = true;
                Evaluation eval = new Evaluation(test[i4]);
                eval.evaluateModel(m_roots[i4], test[i4], new Object[0]);
                double error = this.m_UseErrorRate ? eval.errorRate() : eval.rootMeanSquaredError();
                modelError[i4].addElement(new Double(error));
                m_roots[i4].m_isLeaf = false;
                BFTree nodeToSplit = (BFTree)((FastVector)parallelBFElements[i4].elementAt(0)).elementAt(0);
                m_roots[i4].makeTree(parallelBFElements[i4], m_roots[i4], train[i4], test[i4], modelError[i4], nodeToSplit.m_SortedIndices, nodeToSplit.m_Weights, nodeToSplit.m_Dists, nodeToSplit.m_ClassProbs, nodeToSplit.m_TotalWeight, nodeToSplit.m_Props, this.m_minNumObj, this.m_Heuristic, this.m_UseGini, this.m_UseErrorRate);
                m_roots[i4] = null;
                ++i4;
            }
            double minError = Double.MAX_VALUE;
            int maxExpansion = modelError[0].size();
            int i5 = 1;
            while (i5 < modelError.length) {
                if (modelError[i5].size() > maxExpansion) {
                    maxExpansion = modelError[i5].size();
                }
                ++i5;
            }
            double[] error = new double[maxExpansion];
            int[] counts = new int[maxExpansion];
            int i6 = 0;
            while (i6 < maxExpansion) {
                counts[i6] = 0;
                error[i6] = 0.0;
                int j = 0;
                while (j < this.m_numFoldsPruning) {
                    if (i6 < modelError[j].size()) {
                        int n = i6;
                        error[n] = error[n] + (Double)modelError[j].elementAt(i6);
                        int n2 = i6;
                        counts[n2] = counts[n2] + 1;
                    }
                    ++j;
                }
                error[i6] = error[i6] / (double)counts[i6];
                if (error[i6] < minError) {
                    minError = error[i6];
                    expansion = i6;
                }
                ++i6;
            }
            if (this.m_UseOneSE) {
                double oneSE = Math.sqrt(minError * (1.0 - minError) / (double)data.numInstances());
                int i7 = 0;
                while (i7 < maxExpansion) {
                    if (error[i7] <= minError + oneSE) {
                        expansion = i7;
                        break;
                    }
                    ++i7;
                }
            }
        }
        int[][] prune_sortedIndices = new int[data.numAttributes()][0];
        double[][] prune_weights = new double[data.numAttributes()][0];
        double[] prune_classProbs = new double[data.numClasses()];
        double prune_totalWeight = this.computeSortedInfo(data, prune_sortedIndices, prune_weights, prune_classProbs);
        double[][][] prune_dists = new double[data.numAttributes()][2][data.numClasses()];
        double[][] prune_props = new double[data.numAttributes()][2];
        double[][] prune_totalSubsetWeights = new double[data.numAttributes()][2];
        FastVector prune_nodeInfo = this.computeSplitInfo(this, data, prune_sortedIndices, prune_weights, prune_dists, prune_props, prune_totalSubsetWeights, this.m_Heuristic, this.m_UseGini);
        FastVector BestFirstElements = new FastVector();
        BestFirstElements.addElement(prune_nodeInfo);
        int attIndex = ((Attribute)prune_nodeInfo.elementAt(1)).index();
        m_Expansion = 0;
        this.makeTree(BestFirstElements, data, prune_sortedIndices, prune_weights, prune_dists, prune_classProbs, prune_totalWeight, prune_props[attIndex], this.m_minNumObj, this.m_Heuristic, this.m_UseGini, expansion);
    }

    protected void makeTree(FastVector BestFirstElements, Instances data, int[][] sortedIndices, double[][] weights, double[][][] dists, double[] classProbs, double totalWeight, double[] branchProps, int minNumObj, boolean useHeuristic, boolean useGini, int preExpansion) throws Exception {
        int i;
        if (BestFirstElements.size() == 0) {
            return;
        }
        FastVector firstElement = (FastVector)BestFirstElements.elementAt(0);
        Attribute att = (Attribute)firstElement.elementAt(1);
        double splitValue = Double.NaN;
        String splitStr = null;
        if (att.isNumeric()) {
            splitValue = (Double)firstElement.elementAt(2);
        } else {
            splitStr = ((String)firstElement.elementAt(2)).toString();
        }
        double gain = (Double)firstElement.elementAt(3);
        if (this.m_ClassProbs == null) {
            this.m_SortedIndices = new int[sortedIndices.length][0];
            this.m_Weights = new double[weights.length][0];
            this.m_Dists = new double[dists.length][0][0];
            this.m_ClassProbs = new double[classProbs.length];
            this.m_Distribution = new double[classProbs.length];
            this.m_Props = new double[2];
            i = 0;
            while (i < this.m_SortedIndices.length) {
                this.m_SortedIndices[i] = sortedIndices[i];
                this.m_Weights[i] = weights[i];
                this.m_Dists[i] = dists[i];
                ++i;
            }
            System.arraycopy(classProbs, 0, this.m_ClassProbs, 0, classProbs.length);
            System.arraycopy(classProbs, 0, this.m_Distribution, 0, classProbs.length);
            System.arraycopy(branchProps, 0, this.m_Props, 0, this.m_Props.length);
            this.m_TotalWeight = totalWeight;
            if (Utils.sum(this.m_ClassProbs) != 0.0) {
                Utils.normalize(this.m_ClassProbs);
            }
        }
        if (totalWeight < (double)(2 * minNumObj) || branchProps[0] == 0.0 || branchProps[1] == 0.0) {
            BestFirstElements.removeElementAt(0);
            this.makeLeaf(data);
            if (BestFirstElements.size() != 0) {
                FastVector nextSplitElement = (FastVector)BestFirstElements.elementAt(0);
                BFTree nextSplitNode = (BFTree)nextSplitElement.elementAt(0);
                nextSplitNode.makeTree(BestFirstElements, data, nextSplitNode.m_SortedIndices, nextSplitNode.m_Weights, nextSplitNode.m_Dists, nextSplitNode.m_ClassProbs, nextSplitNode.m_TotalWeight, nextSplitNode.m_Props, minNumObj, useHeuristic, useGini, preExpansion);
            }
            return;
        }
        if (gain == 0.0 || preExpansion == m_Expansion) {
            i = 0;
            while (i < BestFirstElements.size()) {
                FastVector element = (FastVector)BestFirstElements.elementAt(i);
                BFTree node = (BFTree)element.elementAt(0);
                node.makeLeaf(data);
                ++i;
            }
            BestFirstElements.removeAllElements();
        } else {
            BestFirstElements.removeElementAt(0);
            this.m_Attribute = att;
            if (this.m_Attribute.isNumeric()) {
                this.m_SplitValue = splitValue;
            } else {
                this.m_SplitString = splitStr;
            }
            int[][][] subsetIndices = new int[2][data.numAttributes()][0];
            double[][][] subsetWeights = new double[2][data.numAttributes()][0];
            this.splitData(subsetIndices, subsetWeights, this.m_Attribute, this.m_SplitValue, this.m_SplitString, sortedIndices, weights, data);
            int attIndex = att.index();
            if (subsetIndices[0][attIndex].length < minNumObj || subsetIndices[1][attIndex].length < minNumObj) {
                this.makeLeaf(data);
            } else {
                this.m_isLeaf = false;
                this.m_Attribute = att;
                if (this.m_PruningStrategy == 2 || this.m_PruningStrategy == 1 || preExpansion != -1) {
                    ++m_Expansion;
                }
                this.makeSuccessors(BestFirstElements, data, subsetIndices, subsetWeights, dists, att, useHeuristic, useGini);
            }
            if (BestFirstElements.size() != 0) {
                FastVector nextSplitElement = (FastVector)BestFirstElements.elementAt(0);
                BFTree nextSplitNode = (BFTree)nextSplitElement.elementAt(0);
                nextSplitNode.makeTree(BestFirstElements, data, nextSplitNode.m_SortedIndices, nextSplitNode.m_Weights, nextSplitNode.m_Dists, nextSplitNode.m_ClassProbs, nextSplitNode.m_TotalWeight, nextSplitNode.m_Props, minNumObj, useHeuristic, useGini, preExpansion);
            }
        }
    }

    protected boolean makeTree(FastVector BestFirstElements, BFTree root, Instances train, int[][] sortedIndices, double[][] weights, double[][][] dists, double[] classProbs, double totalWeight, double[] branchProps, int minNumObj, boolean useHeuristic, boolean useGini) throws Exception {
        if (BestFirstElements.size() == 0) {
            return false;
        }
        FastVector firstElement = (FastVector)BestFirstElements.elementAt(0);
        BFTree nodeToSplit = (BFTree)firstElement.elementAt(0);
        Attribute att = (Attribute)firstElement.elementAt(1);
        double splitValue = Double.NaN;
        String splitStr = null;
        if (att.isNumeric()) {
            splitValue = (Double)firstElement.elementAt(2);
        } else {
            splitStr = ((String)firstElement.elementAt(2)).toString();
        }
        double gain = (Double)firstElement.elementAt(3);
        if (totalWeight < (double)(2 * minNumObj) || branchProps[0] == 0.0 || branchProps[1] == 0.0) {
            BestFirstElements.removeElementAt(0);
            nodeToSplit.makeLeaf(train);
            if (BestFirstElements.size() == 0) {
                return false;
            }
            BFTree nextNode = (BFTree)((FastVector)BestFirstElements.elementAt(0)).elementAt(0);
            return root.makeTree(BestFirstElements, root, train, nextNode.m_SortedIndices, nextNode.m_Weights, nextNode.m_Dists, nextNode.m_ClassProbs, nextNode.m_TotalWeight, nextNode.m_Props, minNumObj, useHeuristic, useGini);
        }
        if (gain == 0.0) {
            int i = 0;
            while (i < BestFirstElements.size()) {
                FastVector element = (FastVector)BestFirstElements.elementAt(i);
                BFTree node = (BFTree)element.elementAt(0);
                node.makeLeaf(train);
                ++i;
            }
            BestFirstElements.removeAllElements();
            return false;
        }
        BestFirstElements.removeElementAt(0);
        nodeToSplit.m_Attribute = att;
        if (att.isNumeric()) {
            nodeToSplit.m_SplitValue = splitValue;
        } else {
            nodeToSplit.m_SplitString = splitStr;
        }
        int[][][] subsetIndices = new int[2][train.numAttributes()][0];
        double[][][] subsetWeights = new double[2][train.numAttributes()][0];
        this.splitData(subsetIndices, subsetWeights, nodeToSplit.m_Attribute, nodeToSplit.m_SplitValue, nodeToSplit.m_SplitString, nodeToSplit.m_SortedIndices, nodeToSplit.m_Weights, train);
        int attIndex = att.index();
        if (subsetIndices[0][attIndex].length < minNumObj || subsetIndices[1][attIndex].length < minNumObj) {
            nodeToSplit.makeLeaf(train);
            BFTree nextNode = (BFTree)((FastVector)BestFirstElements.elementAt(0)).elementAt(0);
            return root.makeTree(BestFirstElements, root, train, nextNode.m_SortedIndices, nextNode.m_Weights, nextNode.m_Dists, nextNode.m_ClassProbs, nextNode.m_TotalWeight, nextNode.m_Props, minNumObj, useHeuristic, useGini);
        }
        nodeToSplit.m_isLeaf = false;
        nodeToSplit.m_Attribute = att;
        nodeToSplit.makeSuccessors(BestFirstElements, train, subsetIndices, subsetWeights, dists, nodeToSplit.m_Attribute, useHeuristic, useGini);
        int i = 0;
        while (i < 2) {
            nodeToSplit.m_Successors[i].makeLeaf(train);
            ++i;
        }
        return true;
    }

    protected void makeTree(FastVector BestFirstElements, BFTree root, Instances train, Instances test, FastVector modelError, int[][] sortedIndices, double[][] weights, double[][][] dists, double[] classProbs, double totalWeight, double[] branchProps, int minNumObj, boolean useHeuristic, boolean useGini, boolean useErrorRate) throws Exception {
        if (BestFirstElements.size() == 0) {
            return;
        }
        FastVector firstElement = (FastVector)BestFirstElements.elementAt(0);
        Attribute att = (Attribute)firstElement.elementAt(1);
        double splitValue = Double.NaN;
        String splitStr = null;
        if (att.isNumeric()) {
            splitValue = (Double)firstElement.elementAt(2);
        } else {
            splitStr = ((String)firstElement.elementAt(2)).toString();
        }
        double gain = (Double)firstElement.elementAt(3);
        if (totalWeight < (double)(2 * minNumObj) || branchProps[0] == 0.0 || branchProps[1] == 0.0) {
            BestFirstElements.removeElementAt(0);
            this.makeLeaf(train);
            if (BestFirstElements.size() == 0) {
                return;
            }
            BFTree nextSplitNode = (BFTree)((FastVector)BestFirstElements.elementAt(0)).elementAt(0);
            nextSplitNode.makeTree(BestFirstElements, root, train, test, modelError, nextSplitNode.m_SortedIndices, nextSplitNode.m_Weights, nextSplitNode.m_Dists, nextSplitNode.m_ClassProbs, nextSplitNode.m_TotalWeight, nextSplitNode.m_Props, minNumObj, useHeuristic, useGini, useErrorRate);
            return;
        }
        if (gain == 0.0) {
            int i = 0;
            while (i < BestFirstElements.size()) {
                FastVector element = (FastVector)BestFirstElements.elementAt(i);
                BFTree node = (BFTree)element.elementAt(0);
                node.makeLeaf(train);
                ++i;
            }
            BestFirstElements.removeAllElements();
        } else {
            BestFirstElements.removeElementAt(0);
            this.m_Attribute = att;
            if (att.isNumeric()) {
                this.m_SplitValue = splitValue;
            } else {
                this.m_SplitString = splitStr;
            }
            int[][][] subsetIndices = new int[2][train.numAttributes()][0];
            double[][][] subsetWeights = new double[2][train.numAttributes()][0];
            this.splitData(subsetIndices, subsetWeights, this.m_Attribute, this.m_SplitValue, this.m_SplitString, sortedIndices, weights, train);
            int attIndex = att.index();
            if (subsetIndices[0][attIndex].length < minNumObj || subsetIndices[1][attIndex].length < minNumObj) {
                this.makeLeaf(train);
            } else {
                this.m_isLeaf = false;
                this.m_Attribute = att;
                this.makeSuccessors(BestFirstElements, train, subsetIndices, subsetWeights, dists, this.m_Attribute, useHeuristic, useGini);
                int i = 0;
                while (i < 2) {
                    this.m_Successors[i].makeLeaf(train);
                    ++i;
                }
                Evaluation eval = new Evaluation(test);
                eval.evaluateModel(root, test, new Object[0]);
                double error = useErrorRate ? eval.errorRate() : eval.rootMeanSquaredError();
                modelError.addElement(new Double(error));
            }
            if (BestFirstElements.size() != 0) {
                FastVector nextSplitElement = (FastVector)BestFirstElements.elementAt(0);
                BFTree nextSplitNode = (BFTree)nextSplitElement.elementAt(0);
                nextSplitNode.makeTree(BestFirstElements, root, train, test, modelError, nextSplitNode.m_SortedIndices, nextSplitNode.m_Weights, nextSplitNode.m_Dists, nextSplitNode.m_ClassProbs, nextSplitNode.m_TotalWeight, nextSplitNode.m_Props, minNumObj, useHeuristic, useGini, useErrorRate);
            }
        }
    }

    protected void makeSuccessors(FastVector BestFirstElements, Instances data, int[][][] subsetSortedIndices, double[][][] subsetWeights, double[][][] dists, Attribute att, boolean useHeuristic, boolean useGini) throws Exception {
        this.m_Successors = new BFTree[2];
        int i = 0;
        while (i < 2) {
            this.m_Successors[i] = new BFTree();
            this.m_Successors[i].m_isLeaf = true;
            this.m_Successors[i].m_ClassProbs = new double[data.numClasses()];
            this.m_Successors[i].m_Distribution = new double[data.numClasses()];
            System.arraycopy(dists[att.index()][i], 0, this.m_Successors[i].m_ClassProbs, 0, this.m_Successors[i].m_ClassProbs.length);
            System.arraycopy(dists[att.index()][i], 0, this.m_Successors[i].m_Distribution, 0, this.m_Successors[i].m_Distribution.length);
            if (Utils.sum(this.m_Successors[i].m_ClassProbs) != 0.0) {
                Utils.normalize(this.m_Successors[i].m_ClassProbs);
            }
            double[][] props = new double[data.numAttributes()][2];
            double[][][] subDists = new double[data.numAttributes()][2][data.numClasses()];
            double[][] totalSubsetWeights = new double[data.numAttributes()][2];
            FastVector splitInfo = this.m_Successors[i].computeSplitInfo(this.m_Successors[i], data, subsetSortedIndices[i], subsetWeights[i], subDists, props, totalSubsetWeights, useHeuristic, useGini);
            int splitIndex = ((Attribute)splitInfo.elementAt(1)).index();
            this.m_Successors[i].m_Props = new double[2];
            System.arraycopy(props[splitIndex], 0, this.m_Successors[i].m_Props, 0, this.m_Successors[i].m_Props.length);
            this.m_Successors[i].m_SortedIndices = new int[data.numAttributes()][0];
            this.m_Successors[i].m_Weights = new double[data.numAttributes()][0];
            int j = 0;
            while (j < this.m_Successors[i].m_SortedIndices.length) {
                this.m_Successors[i].m_SortedIndices[j] = subsetSortedIndices[i][j];
                this.m_Successors[i].m_Weights[j] = subsetWeights[i][j];
                ++j;
            }
            this.m_Successors[i].m_Dists = new double[data.numAttributes()][2][data.numClasses()];
            j = 0;
            while (j < subDists.length) {
                this.m_Successors[i].m_Dists[j] = subDists[j];
                ++j;
            }
            this.m_Successors[i].m_TotalWeight = Utils.sum(totalSubsetWeights[splitIndex]);
            if (BestFirstElements.size() == 0) {
                BestFirstElements.addElement(splitInfo);
            } else {
                int vectorSize;
                FastVector lastNode;
                double gGain = (Double)splitInfo.elementAt(3);
                if (gGain < (Double)(lastNode = (FastVector)BestFirstElements.elementAt((vectorSize = BestFirstElements.size()) - 1)).elementAt(3)) {
                    BestFirstElements.insertElementAt(splitInfo, vectorSize);
                } else {
                    int j2 = 0;
                    while (j2 < vectorSize) {
                        FastVector node = (FastVector)BestFirstElements.elementAt(j2);
                        double nodeGain = (Double)node.elementAt(3);
                        if (gGain >= nodeGain) {
                            BestFirstElements.insertElementAt(splitInfo, j2);
                            break;
                        }
                        ++j2;
                    }
                }
            }
            ++i;
        }
    }

    protected double computeSortedInfo(Instances data, int[][] sortedIndices, double[][] weights, double[] classProbs) throws Exception {
        Instance inst;
        double[] vals = new double[data.numInstances()];
        int j = 0;
        while (j < data.numAttributes()) {
            if (j != data.classIndex()) {
                weights[j] = new double[data.numInstances()];
                if (data.attribute(j).isNominal()) {
                    sortedIndices[j] = new int[data.numInstances()];
                    int count = 0;
                    int i = 0;
                    while (i < data.numInstances()) {
                        inst = data.instance(i);
                        if (!inst.isMissing(j)) {
                            sortedIndices[j][count] = i;
                            weights[j][count] = inst.weight();
                            ++count;
                        }
                        ++i;
                    }
                    i = 0;
                    while (i < data.numInstances()) {
                        inst = data.instance(i);
                        if (inst.isMissing(j)) {
                            sortedIndices[j][count] = i;
                            weights[j][count] = inst.weight();
                            ++count;
                        }
                        ++i;
                    }
                } else {
                    int i = 0;
                    while (i < data.numInstances()) {
                        Instance inst2 = data.instance(i);
                        vals[i] = inst2.value(j);
                        ++i;
                    }
                    sortedIndices[j] = Utils.sort(vals);
                    i = 0;
                    while (i < data.numInstances()) {
                        weights[j][i] = data.instance(sortedIndices[j][i]).weight();
                        ++i;
                    }
                }
            }
            ++j;
        }
        double totalWeight = 0.0;
        int i = 0;
        while (i < data.numInstances()) {
            inst = data.instance(i);
            int n = (int)inst.classValue();
            classProbs[n] = classProbs[n] + inst.weight();
            totalWeight += inst.weight();
            ++i;
        }
        return totalWeight;
    }

    protected FastVector computeSplitInfo(BFTree node, Instances data, int[][] sortedIndices, double[][] weights, double[][][] dists, double[][] props, double[][] totalSubsetWeights, boolean useHeuristic, boolean useGini) throws Exception {
        double[] splits = new double[data.numAttributes()];
        String[] splitString = new String[data.numAttributes()];
        double[] gains = new double[data.numAttributes()];
        int i = 0;
        while (i < data.numAttributes()) {
            if (i != data.classIndex()) {
                Attribute att = data.attribute(i);
                if (att.isNumeric()) {
                    splits[i] = this.numericDistribution(props, dists, att, sortedIndices[i], weights[i], totalSubsetWeights, gains, data, useGini);
                } else {
                    splitString[i] = this.nominalDistribution(props, dists, att, sortedIndices[i], weights[i], totalSubsetWeights, gains, data, useHeuristic, useGini);
                }
            }
            ++i;
        }
        int index = Utils.maxIndex(gains);
        double mBestGain = gains[index];
        Attribute att = data.attribute(index);
        double mValue = Double.NaN;
        String mString = null;
        if (att.isNumeric()) {
            mValue = splits[index];
        } else {
            mString = splitString[index];
            if (mString == null) {
                mString = "";
            }
        }
        FastVector splitInfo = new FastVector();
        splitInfo.addElement(node);
        splitInfo.addElement(att);
        if (att.isNumeric()) {
            splitInfo.addElement(new Double(mValue));
        } else {
            splitInfo.addElement(mString);
        }
        splitInfo.addElement(new Double(mBestGain));
        return splitInfo;
    }

    protected double numericDistribution(double[][] props, double[][][] dists, Attribute att, int[] sortedIndices, double[] weights, double[][] subsetWeights, double[] gains, Instances data, boolean useGini) throws Exception {
        double splitPoint = Double.NaN;
        double[][] dist = null;
        int numClasses = data.numClasses();
        double[][] currDist = new double[2][numClasses];
        dist = new double[2][numClasses];
        double[] parentDist = new double[numClasses];
        int missingStart = 0;
        int j = 0;
        while (j < sortedIndices.length) {
            Instance inst = data.instance(sortedIndices[j]);
            if (!inst.isMissing(att)) {
                ++missingStart;
                double[] dArray = currDist[1];
                int n = (int)inst.classValue();
                dArray[n] = dArray[n] + weights[j];
            }
            int n = (int)inst.classValue();
            parentDist[n] = parentDist[n] + weights[j];
            ++j;
        }
        System.arraycopy(currDist[1], 0, dist[1], 0, dist[1].length);
        double currSplit = data.instance(sortedIndices[0]).value(att);
        double bestGain = -1.7976931348623157E308;
        int i = 0;
        while (i < sortedIndices.length) {
            Instance inst = data.instance(sortedIndices[i]);
            if (inst.isMissing(att)) break;
            if (inst.value(att) > currSplit) {
                double[][] tempDist = new double[2][numClasses];
                int k = 0;
                while (k < 2) {
                    System.arraycopy(currDist[k], 0, tempDist[k], 0, tempDist[k].length);
                    ++k;
                }
                double[] tempProps = new double[2];
                int k2 = 0;
                while (k2 < 2) {
                    tempProps[k2] = Utils.sum(tempDist[k2]);
                    ++k2;
                }
                if (Utils.sum(tempProps) != 0.0) {
                    Utils.normalize(tempProps);
                }
                int index = missingStart;
                while (index < sortedIndices.length) {
                    Instance insta = data.instance(sortedIndices[index]);
                    int j2 = 0;
                    while (j2 < 2) {
                        double[] dArray = tempDist[j2];
                        int n = (int)insta.classValue();
                        dArray[n] = dArray[n] + tempProps[j2] * weights[index];
                        ++j2;
                    }
                    ++index;
                }
                double currGain = useGini ? this.computeGiniGain(parentDist, tempDist) : this.computeInfoGain(parentDist, tempDist);
                if (currGain > bestGain) {
                    bestGain = currGain;
                    splitPoint = Math.rint((inst.value(att) + currSplit) / 2.0 * 100000.0) / 100000.0;
                    int j3 = 0;
                    while (j3 < currDist.length) {
                        System.arraycopy(tempDist[j3], 0, dist[j3], 0, dist[j3].length);
                        ++j3;
                    }
                }
            }
            currSplit = inst.value(att);
            double[] dArray = currDist[0];
            int n = (int)inst.classValue();
            dArray[n] = dArray[n] + weights[i];
            double[] dArray2 = currDist[1];
            int n2 = (int)inst.classValue();
            dArray2[n2] = dArray2[n2] - weights[i];
            ++i;
        }
        int attIndex = att.index();
        props[attIndex] = new double[2];
        int k = 0;
        while (k < 2) {
            props[attIndex][k] = Utils.sum(dist[k]);
            ++k;
        }
        if (Utils.sum(props[attIndex]) != 0.0) {
            Utils.normalize(props[attIndex]);
        }
        subsetWeights[attIndex] = new double[2];
        int j4 = 0;
        while (j4 < 2) {
            double[] dArray = subsetWeights[attIndex];
            int n = j4;
            dArray[n] = dArray[n] + Utils.sum(dist[j4]);
            ++j4;
        }
        gains[attIndex] = Math.rint(bestGain * 1.0E7) / 1.0E7;
        dists[attIndex] = dist;
        return splitPoint;
    }

    protected String nominalDistribution(double[][] props, double[][][] dists, Attribute att, int[] sortedIndices, double[] weights, double[][] subsetWeights, double[] gains, Instances data, boolean useHeuristic, boolean useGini) throws Exception {
        String[] values = new String[att.numValues()];
        int numCat = values.length;
        int numClasses = data.numClasses();
        String bestSplitString = "";
        double bestGain = -1.7976931348623157E308;
        int[] classFreq = new int[numCat];
        int j = 0;
        while (j < numCat) {
            classFreq[j] = 0;
            ++j;
        }
        double[] parentDist = new double[numClasses];
        double[][] currDist = new double[2][numClasses];
        double[][] dist = new double[2][numClasses];
        int missingStart = 0;
        int i = 0;
        while (i < sortedIndices.length) {
            Instance inst = data.instance(sortedIndices[i]);
            if (!inst.isMissing(att)) {
                ++missingStart;
                int n = (int)inst.value(att);
                classFreq[n] = classFreq[n] + 1;
            }
            int n = (int)inst.classValue();
            parentDist[n] = parentDist[n] + weights[i];
            ++i;
        }
        int nonEmpty = 0;
        int j2 = 0;
        while (j2 < numCat) {
            if (classFreq[j2] != 0) {
                ++nonEmpty;
            }
            ++j2;
        }
        String[] nonEmptyValues = new String[nonEmpty];
        int nonEmptyIndex = 0;
        int j3 = 0;
        while (j3 < numCat) {
            if (classFreq[j3] != 0) {
                nonEmptyValues[nonEmptyIndex] = att.value(j3);
                ++nonEmptyIndex;
            }
            ++j3;
        }
        int empty = numCat - nonEmpty;
        String[] emptyValues = new String[empty];
        int emptyIndex = 0;
        int j4 = 0;
        while (j4 < numCat) {
            if (classFreq[j4] == 0) {
                emptyValues[emptyIndex] = att.value(j4);
                ++emptyIndex;
            }
            ++j4;
        }
        if (nonEmpty <= 1) {
            gains[att.index()] = 0.0;
            return "";
        }
        if (data.numClasses() == 2) {
            int j5;
            double[] pClass0 = new double[nonEmpty];
            double[][] valDist = new double[nonEmpty][2];
            int j6 = 0;
            while (j6 < nonEmpty) {
                int k = 0;
                while (k < 2) {
                    valDist[j6][k] = 0.0;
                    ++k;
                }
                ++j6;
            }
            int i2 = 0;
            while (i2 < sortedIndices.length) {
                Instance inst = data.instance(sortedIndices[i2]);
                if (inst.isMissing(att)) break;
                j5 = 0;
                while (j5 < nonEmpty) {
                    if (att.value((int)inst.value(att)).compareTo(nonEmptyValues[j5]) == 0) {
                        double[] dArray = valDist[j5];
                        int n = (int)inst.classValue();
                        dArray[n] = dArray[n] + inst.weight();
                        break;
                    }
                    ++j5;
                }
                ++i2;
            }
            j6 = 0;
            while (j6 < nonEmpty) {
                double distSum = Utils.sum(valDist[j6]);
                pClass0[j6] = distSum == 0.0 ? 0.0 : valDist[j6][0] / distSum;
                ++j6;
            }
            String[] sortedValues = new String[nonEmpty];
            int j7 = 0;
            while (j7 < nonEmpty) {
                sortedValues[j7] = nonEmptyValues[Utils.minIndex(pClass0)];
                pClass0[Utils.minIndex((double[])pClass0)] = Double.MAX_VALUE;
                ++j7;
            }
            String tempStr = "";
            j5 = 0;
            while (j5 < nonEmpty - 1) {
                currDist = new double[2][numClasses];
                tempStr = tempStr == "" ? "(" + sortedValues[j5] + ")" : String.valueOf(tempStr) + "|(" + sortedValues[j5] + ")";
                int i3 = 0;
                while (i3 < sortedIndices.length) {
                    Instance inst = data.instance(sortedIndices[i3]);
                    if (inst.isMissing(att)) break;
                    if (tempStr.indexOf("(" + att.value((int)inst.value(att)) + ")") != -1) {
                        double[] dArray = currDist[0];
                        int n = (int)inst.classValue();
                        dArray[n] = dArray[n] + weights[i3];
                    } else {
                        double[] dArray = currDist[1];
                        int n = (int)inst.classValue();
                        dArray[n] = dArray[n] + weights[i3];
                    }
                    ++i3;
                }
                double[][] tempDist = new double[2][numClasses];
                int kk = 0;
                while (kk < 2) {
                    tempDist[kk] = currDist[kk];
                    ++kk;
                }
                double[] tempProps = new double[2];
                int kk2 = 0;
                while (kk2 < 2) {
                    tempProps[kk2] = Utils.sum(tempDist[kk2]);
                    ++kk2;
                }
                if (Utils.sum(tempProps) != 0.0) {
                    Utils.normalize(tempProps);
                }
                int mstart = missingStart;
                while (mstart < sortedIndices.length) {
                    Instance insta = data.instance(sortedIndices[mstart]);
                    int jj = 0;
                    while (jj < 2) {
                        double[] dArray = tempDist[jj];
                        int n = (int)insta.classValue();
                        dArray[n] = dArray[n] + tempProps[jj] * weights[mstart];
                        ++jj;
                    }
                    ++mstart;
                }
                double currGain = useGini ? this.computeGiniGain(parentDist, tempDist) : this.computeInfoGain(parentDist, tempDist);
                if (currGain > bestGain) {
                    bestGain = currGain;
                    bestSplitString = tempStr;
                    int jj = 0;
                    while (jj < 2) {
                        System.arraycopy(tempDist[jj], 0, dist[jj], 0, dist[jj].length);
                        ++jj;
                    }
                }
                ++j5;
            }
        } else if (!useHeuristic || nonEmpty <= 4) {
            int i4 = 0;
            while (i4 < (int)Math.pow(2.0, nonEmpty - 1)) {
                String tempStr = "";
                currDist = new double[2][numClasses];
                int bit10 = i4;
                int j8 = nonEmpty - 1;
                while (j8 >= 0) {
                    int mod = bit10 % 2;
                    if (mod == 1) {
                        tempStr = tempStr == "" ? "(" + nonEmptyValues[j8] + ")" : String.valueOf(tempStr) + "|(" + nonEmptyValues[j8] + ")";
                    }
                    bit10 /= 2;
                    --j8;
                }
                j8 = 0;
                while (j8 < sortedIndices.length) {
                    Instance inst = data.instance(sortedIndices[j8]);
                    if (inst.isMissing(att)) break;
                    if (tempStr.indexOf("(" + att.value((int)inst.value(att)) + ")") != -1) {
                        double[] dArray = currDist[0];
                        int n = (int)inst.classValue();
                        dArray[n] = dArray[n] + weights[j8];
                    } else {
                        double[] dArray = currDist[1];
                        int n = (int)inst.classValue();
                        dArray[n] = dArray[n] + weights[j8];
                    }
                    ++j8;
                }
                double[][] tempDist = new double[2][numClasses];
                int k = 0;
                while (k < 2) {
                    tempDist[k] = currDist[k];
                    ++k;
                }
                double[] tempProps = new double[2];
                int k2 = 0;
                while (k2 < 2) {
                    tempProps[k2] = Utils.sum(tempDist[k2]);
                    ++k2;
                }
                if (Utils.sum(tempProps) != 0.0) {
                    Utils.normalize(tempProps);
                }
                int index = missingStart;
                while (index < sortedIndices.length) {
                    Instance insta = data.instance(sortedIndices[index]);
                    int j9 = 0;
                    while (j9 < 2) {
                        double[] dArray = tempDist[j9];
                        int n = (int)insta.classValue();
                        dArray[n] = dArray[n] + tempProps[j9] * weights[index];
                        ++j9;
                    }
                    ++index;
                }
                double currGain = useGini ? this.computeGiniGain(parentDist, tempDist) : this.computeInfoGain(parentDist, tempDist);
                if (currGain > bestGain) {
                    bestGain = currGain;
                    bestSplitString = tempStr;
                    int j10 = 0;
                    while (j10 < 2) {
                        System.arraycopy(tempDist[j10], 0, dist[j10], 0, dist[j10].length);
                        ++j10;
                    }
                }
                ++i4;
            }
        } else {
            int n = nonEmpty;
            int k = data.numClasses();
            double[][] P = new double[n][k];
            int[] numInstancesValue = new int[n];
            double[] meanClass = new double[k];
            int numInstances = data.numInstances();
            int j11 = 0;
            while (j11 < meanClass.length) {
                meanClass[j11] = 0.0;
                ++j11;
            }
            j11 = 0;
            while (j11 < numInstances) {
                Instance inst = data.instance(j11);
                int valueIndex = 0;
                int i5 = 0;
                while (i5 < nonEmpty) {
                    if (att.value((int)inst.value(att)).compareToIgnoreCase(nonEmptyValues[i5]) == 0) {
                        valueIndex = i5;
                        break;
                    }
                    ++i5;
                }
                double[] dArray = P[valueIndex];
                int n2 = (int)inst.classValue();
                dArray[n2] = dArray[n2] + 1.0;
                int n3 = valueIndex;
                numInstancesValue[n3] = numInstancesValue[n3] + 1;
                int n4 = (int)inst.classValue();
                meanClass[n4] = meanClass[n4] + 1.0;
                ++j11;
            }
            int i6 = 0;
            while (i6 < P.length) {
                int j12 = 0;
                while (j12 < P[0].length) {
                    if (numInstancesValue[i6] == 0) {
                        P[i6][j12] = 0.0;
                    } else {
                        double[] dArray = P[i6];
                        int n5 = j12;
                        dArray[n5] = dArray[n5] / (double)numInstancesValue[i6];
                    }
                    ++j12;
                }
                ++i6;
            }
            i6 = 0;
            while (i6 < meanClass.length) {
                int n6 = i6++;
                meanClass[n6] = meanClass[n6] / (double)numInstances;
            }
            double[][] covariance = new double[k][k];
            int i1 = 0;
            while (i1 < k) {
                int i2 = 0;
                while (i2 < k) {
                    double element = 0.0;
                    int j13 = 0;
                    while (j13 < n) {
                        element += (P[j13][i2] - meanClass[i2]) * (P[j13][i1] - meanClass[i1]) * (double)numInstancesValue[j13];
                        ++j13;
                    }
                    covariance[i1][i2] = element;
                    ++i2;
                }
                ++i1;
            }
            Matrix matrix = new Matrix(covariance);
            EigenvalueDecomposition eigen = new EigenvalueDecomposition(matrix);
            double[] eigenValues = eigen.getRealEigenvalues();
            int index = 0;
            double largest = eigenValues[0];
            int i7 = 1;
            while (i7 < eigenValues.length) {
                if (eigenValues[i7] > largest) {
                    index = i7;
                    largest = eigenValues[i7];
                }
                ++i7;
            }
            double[] FPC = new double[k];
            Matrix eigenVector = eigen.getV();
            double[][] vectorArray = eigenVector.getArray();
            int i8 = 0;
            while (i8 < FPC.length) {
                FPC[i8] = vectorArray[i8][index];
                ++i8;
            }
            double[] Sa = new double[n];
            int i9 = 0;
            while (i9 < Sa.length) {
                Sa[i9] = 0.0;
                int j14 = 0;
                while (j14 < k) {
                    int n7 = i9;
                    Sa[n7] = Sa[n7] + FPC[j14] * P[i9][j14];
                    ++j14;
                }
                ++i9;
            }
            double[] pCopy = new double[n];
            System.arraycopy(Sa, 0, pCopy, 0, n);
            String[] sortedValues = new String[n];
            Arrays.sort(Sa);
            int j15 = 0;
            while (j15 < n) {
                sortedValues[j15] = nonEmptyValues[Utils.minIndex(pCopy)];
                pCopy[Utils.minIndex((double[])pCopy)] = Double.MAX_VALUE;
                ++j15;
            }
            String tempStr = "";
            int j16 = 0;
            while (j16 < nonEmpty - 1) {
                currDist = new double[2][numClasses];
                tempStr = tempStr == "" ? "(" + sortedValues[j16] + ")" : String.valueOf(tempStr) + "|(" + sortedValues[j16] + ")";
                int i10 = 0;
                while (i10 < sortedIndices.length) {
                    Instance inst = data.instance(sortedIndices[i10]);
                    if (inst.isMissing(att)) break;
                    if (tempStr.indexOf("(" + att.value((int)inst.value(att)) + ")") != -1) {
                        double[] dArray = currDist[0];
                        int n8 = (int)inst.classValue();
                        dArray[n8] = dArray[n8] + weights[i10];
                    } else {
                        double[] dArray = currDist[1];
                        int n9 = (int)inst.classValue();
                        dArray[n9] = dArray[n9] + weights[i10];
                    }
                    ++i10;
                }
                double[][] tempDist = new double[2][numClasses];
                int kk = 0;
                while (kk < 2) {
                    tempDist[kk] = currDist[kk];
                    ++kk;
                }
                double[] tempProps = new double[2];
                int kk3 = 0;
                while (kk3 < 2) {
                    tempProps[kk3] = Utils.sum(tempDist[kk3]);
                    ++kk3;
                }
                if (Utils.sum(tempProps) != 0.0) {
                    Utils.normalize(tempProps);
                }
                int mstart = missingStart;
                while (mstart < sortedIndices.length) {
                    Instance insta = data.instance(sortedIndices[mstart]);
                    int jj = 0;
                    while (jj < 2) {
                        double[] dArray = tempDist[jj];
                        int n10 = (int)insta.classValue();
                        dArray[n10] = dArray[n10] + tempProps[jj] * weights[mstart];
                        ++jj;
                    }
                    ++mstart;
                }
                double currGain = useGini ? this.computeGiniGain(parentDist, tempDist) : this.computeInfoGain(parentDist, tempDist);
                if (currGain > bestGain) {
                    bestGain = currGain;
                    bestSplitString = tempStr;
                    int jj = 0;
                    while (jj < 2) {
                        System.arraycopy(tempDist[jj], 0, dist[jj], 0, dist[jj].length);
                        ++jj;
                    }
                }
                ++j16;
            }
        }
        int attIndex = att.index();
        props[attIndex] = new double[2];
        int k = 0;
        while (k < 2) {
            props[attIndex][k] = Utils.sum(dist[k]);
            ++k;
        }
        if (!(Utils.sum(props[attIndex]) > 0.0)) {
            k = 0;
            while (k < props[attIndex].length) {
                props[attIndex][k] = 1.0 / (double)props[attIndex].length;
                ++k;
            }
        } else {
            Utils.normalize(props[attIndex]);
        }
        subsetWeights[attIndex] = new double[2];
        int j17 = 0;
        while (j17 < 2) {
            double[] dArray = subsetWeights[attIndex];
            int n = j17;
            dArray[n] = dArray[n] + Utils.sum(dist[j17]);
            ++j17;
        }
        j17 = 0;
        while (j17 < empty) {
            if (props[attIndex][0] >= props[attIndex][1]) {
                bestSplitString = bestSplitString == "" ? "(" + emptyValues[j17] + ")" : String.valueOf(bestSplitString) + "|(" + emptyValues[j17] + ")";
            }
            ++j17;
        }
        gains[attIndex] = Math.rint(bestGain * 1.0E7) / 1.0E7;
        dists[attIndex] = dist;
        return bestSplitString;
    }

    protected void splitData(int[][][] subsetIndices, double[][][] subsetWeights, Attribute att, double splitPoint, String splitStr, int[][] sortedIndices, double[][] weights, Instances data) throws Exception {
        int i = 0;
        while (i < data.numAttributes()) {
            if (i != data.classIndex()) {
                int[] num = new int[2];
                int k = 0;
                while (k < 2) {
                    subsetIndices[k][i] = new int[sortedIndices[i].length];
                    subsetWeights[k][i] = new double[weights[i].length];
                    ++k;
                }
                int j = 0;
                while (j < sortedIndices[i].length) {
                    Instance inst = data.instance(sortedIndices[i][j]);
                    if (inst.isMissing(att)) {
                        int k2 = 0;
                        while (k2 < 2) {
                            if (this.m_Props[k2] > 0.0) {
                                subsetIndices[k2][i][num[k2]] = sortedIndices[i][j];
                                subsetWeights[k2][i][num[k2]] = this.m_Props[k2] * weights[i][j];
                                int n = k2;
                                num[n] = num[n] + 1;
                            }
                            ++k2;
                        }
                    } else {
                        int subset = att.isNumeric() ? (inst.value(att) < splitPoint ? 0 : 1) : (splitStr.indexOf("(" + att.value((int)inst.value(att.index())) + ")") != -1 ? 0 : 1);
                        subsetIndices[subset][i][num[subset]] = sortedIndices[i][j];
                        subsetWeights[subset][i][num[subset]] = weights[i][j];
                        int n = subset;
                        num[n] = num[n] + 1;
                    }
                    ++j;
                }
                k = 0;
                while (k < 2) {
                    int[] copy = new int[num[k]];
                    System.arraycopy(subsetIndices[k][i], 0, copy, 0, num[k]);
                    subsetIndices[k][i] = copy;
                    double[] copyWeights = new double[num[k]];
                    System.arraycopy(subsetWeights[k][i], 0, copyWeights, 0, num[k]);
                    subsetWeights[k][i] = copyWeights;
                    ++k;
                }
            }
            ++i;
        }
    }

    protected double computeGiniGain(double[] parentDist, double[][] childDist) {
        double totalWeight = Utils.sum(parentDist);
        if (totalWeight == 0.0) {
            return 0.0;
        }
        double leftWeight = Utils.sum(childDist[0]);
        double rightWeight = Utils.sum(childDist[1]);
        double parentGini = this.computeGini(parentDist, totalWeight);
        double leftGini = this.computeGini(childDist[0], leftWeight);
        double rightGini = this.computeGini(childDist[1], rightWeight);
        return parentGini - leftWeight / totalWeight * leftGini - rightWeight / totalWeight * rightGini;
    }

    protected double computeGini(double[] dist, double total) {
        if (total == 0.0) {
            return 0.0;
        }
        double val = 0.0;
        int i = 0;
        while (i < dist.length) {
            val += dist[i] / total * (dist[i] / total);
            ++i;
        }
        return 1.0 - val;
    }

    protected double computeInfoGain(double[] parentDist, double[][] childDist) {
        double totalWeight = Utils.sum(parentDist);
        if (totalWeight == 0.0) {
            return 0.0;
        }
        double leftWeight = Utils.sum(childDist[0]);
        double rightWeight = Utils.sum(childDist[1]);
        double parentInfo = this.computeEntropy(parentDist, totalWeight);
        double leftInfo = this.computeEntropy(childDist[0], leftWeight);
        double rightInfo = this.computeEntropy(childDist[1], rightWeight);
        return parentInfo - leftWeight / totalWeight * leftInfo - rightWeight / totalWeight * rightInfo;
    }

    protected double computeEntropy(double[] dist, double total) {
        if (total == 0.0) {
            return 0.0;
        }
        double entropy = 0.0;
        int i = 0;
        while (i < dist.length) {
            if (dist[i] != 0.0) {
                entropy -= dist[i] / total * Utils.log2(dist[i] / total);
            }
            ++i;
        }
        return entropy;
    }

    protected void makeLeaf(Instances data) {
        this.m_Attribute = null;
        this.m_isLeaf = true;
        this.m_ClassValue = Utils.maxIndex(this.m_ClassProbs);
        this.m_ClassAttribute = data.classAttribute();
    }

    @Override
    public double[] distributionForInstance(Instance instance) throws Exception {
        if (!this.m_isLeaf) {
            if (instance.isMissing(this.m_Attribute)) {
                double[] returnedDist = new double[this.m_ClassProbs.length];
                int i = 0;
                while (i < this.m_Successors.length) {
                    double[] help = this.m_Successors[i].distributionForInstance(instance);
                    if (help != null) {
                        int j = 0;
                        while (j < help.length) {
                            int n = j;
                            returnedDist[n] = returnedDist[n] + this.m_Props[i] * help[j];
                            ++j;
                        }
                    }
                    ++i;
                }
                return returnedDist;
            }
            if (this.m_Attribute.isNominal()) {
                if (this.m_SplitString.indexOf("(" + this.m_Attribute.value((int)instance.value(this.m_Attribute)) + ")") != -1) {
                    return this.m_Successors[0].distributionForInstance(instance);
                }
                return this.m_Successors[1].distributionForInstance(instance);
            }
            if (instance.value(this.m_Attribute) < this.m_SplitValue) {
                return this.m_Successors[0].distributionForInstance(instance);
            }
            return this.m_Successors[1].distributionForInstance(instance);
        }
        return this.m_ClassProbs;
    }

    public String toString() {
        if (this.m_Distribution == null && this.m_Successors == null) {
            return "Best-First: No model built yet.";
        }
        return "Best-First Decision Tree\n" + this.toString(0) + "\n\n" + "Size of the Tree: " + this.numNodes() + "\n\n" + "Number of Leaf Nodes: " + this.numLeaves();
    }

    protected String toString(int level) {
        StringBuffer text = new StringBuffer();
        if (this.m_Attribute == null) {
            if (Instance.isMissingValue(this.m_ClassValue)) {
                text.append(": null");
            } else {
                double correctNum = Math.rint(this.m_Distribution[Utils.maxIndex(this.m_Distribution)] * 100.0) / 100.0;
                double wrongNum = Math.rint((Utils.sum(this.m_Distribution) - this.m_Distribution[Utils.maxIndex(this.m_Distribution)]) * 100.0) / 100.0;
                String str = "(" + correctNum + "/" + wrongNum + ")";
                text.append(": " + this.m_ClassAttribute.value((int)this.m_ClassValue) + str);
            }
        } else {
            int j = 0;
            while (j < 2) {
                text.append("\n");
                int i = 0;
                while (i < level) {
                    text.append("|  ");
                    ++i;
                }
                if (j == 0) {
                    if (this.m_Attribute.isNumeric()) {
                        text.append(String.valueOf(this.m_Attribute.name()) + " < " + this.m_SplitValue);
                    } else {
                        text.append(String.valueOf(this.m_Attribute.name()) + "=" + this.m_SplitString);
                    }
                } else if (this.m_Attribute.isNumeric()) {
                    text.append(String.valueOf(this.m_Attribute.name()) + " >= " + this.m_SplitValue);
                } else {
                    text.append(String.valueOf(this.m_Attribute.name()) + "!=" + this.m_SplitString);
                }
                text.append(this.m_Successors[j].toString(level + 1));
                ++j;
            }
        }
        return text.toString();
    }

    public int numNodes() {
        if (this.m_isLeaf) {
            return 1;
        }
        int size = 1;
        int i = 0;
        while (i < this.m_Successors.length) {
            size += this.m_Successors[i].numNodes();
            ++i;
        }
        return size;
    }

    public int numLeaves() {
        if (this.m_isLeaf) {
            return 1;
        }
        int size = 0;
        int i = 0;
        while (i < this.m_Successors.length) {
            size += this.m_Successors[i].numLeaves();
            ++i;
        }
        return size;
    }

    @Override
    public Enumeration listOptions() {
        Vector result = new Vector();
        Enumeration en = super.listOptions();
        while (en.hasMoreElements()) {
            result.addElement(en.nextElement());
        }
        result.addElement(new Option("\tThe pruning strategy.\n\t(default: " + new SelectedTag(1, TAGS_PRUNING) + ")", "P", 1, "-P " + Tag.toOptionList(TAGS_PRUNING)));
        result.addElement(new Option("\tThe minimal number of instances at the terminal nodes.\n\t(default 2)", "M", 1, "-M <min no>"));
        result.addElement(new Option("\tThe number of folds used in the pruning.\n\t(default 5)", "N", 5, "-N <num folds>"));
        result.addElement(new Option("\tDon't use heuristic search for nominal attributes in multi-class\n\tproblem (default yes).\n", "H", 0, "-H"));
        result.addElement(new Option("\tDon't use Gini index for splitting (default yes),\n\tif not information is used.", "G", 0, "-G"));
        result.addElement(new Option("\tDon't use error rate in internal cross-validation (default yes), \n\tbut root mean squared error.", "R", 0, "-R"));
        result.addElement(new Option("\tUse the 1 SE rule to make pruning decision.\n\t(default no).", "A", 0, "-A"));
        result.addElement(new Option("\tPercentage of training data size (0-1]\n\t(default 1).", "C", 0, "-C"));
        return result.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        super.setOptions(options);
        String tmpStr = Utils.getOption('M', options);
        if (tmpStr.length() != 0) {
            this.setMinNumObj(Integer.parseInt(tmpStr));
        } else {
            this.setMinNumObj(2);
        }
        tmpStr = Utils.getOption('N', options);
        if (tmpStr.length() != 0) {
            this.setNumFoldsPruning(Integer.parseInt(tmpStr));
        } else {
            this.setNumFoldsPruning(5);
        }
        tmpStr = Utils.getOption('C', options);
        if (tmpStr.length() != 0) {
            this.setSizePer(Double.parseDouble(tmpStr));
        } else {
            this.setSizePer(1.0);
        }
        tmpStr = Utils.getOption('P', options);
        if (tmpStr.length() != 0) {
            this.setPruningStrategy(new SelectedTag(tmpStr, TAGS_PRUNING));
        } else {
            this.setPruningStrategy(new SelectedTag(1, TAGS_PRUNING));
        }
        this.setHeuristic(!Utils.getFlag('H', options));
        this.setUseGini(!Utils.getFlag('G', options));
        this.setUseErrorRate(!Utils.getFlag('R', options));
        this.setUseOneSE(Utils.getFlag('A', options));
    }

    @Override
    public String[] getOptions() {
        Vector<String> result = new Vector<String>();
        String[] options = super.getOptions();
        int i = 0;
        while (i < options.length) {
            result.add(options[i]);
            ++i;
        }
        result.add("-M");
        result.add("" + this.getMinNumObj());
        result.add("-N");
        result.add("" + this.getNumFoldsPruning());
        if (!this.getHeuristic()) {
            result.add("-H");
        }
        if (!this.getUseGini()) {
            result.add("-G");
        }
        if (!this.getUseErrorRate()) {
            result.add("-R");
        }
        if (this.getUseOneSE()) {
            result.add("-A");
        }
        result.add("-C");
        result.add("" + this.getSizePer());
        result.add("-P");
        result.add("" + this.getPruningStrategy());
        return result.toArray(new String[result.size()]);
    }

    @Override
    public Enumeration enumerateMeasures() {
        Vector<String> result = new Vector<String>();
        result.addElement("measureTreeSize");
        return result.elements();
    }

    public double measureTreeSize() {
        return this.numNodes();
    }

    @Override
    public double getMeasure(String additionalMeasureName) {
        if (additionalMeasureName.compareToIgnoreCase("measureTreeSize") == 0) {
            return this.measureTreeSize();
        }
        throw new IllegalArgumentException(String.valueOf(additionalMeasureName) + " not supported (Best-First)");
    }

    public String pruningStrategyTipText() {
        return "Sets the pruning strategy.";
    }

    public void setPruningStrategy(SelectedTag value) {
        if (value.getTags() == TAGS_PRUNING) {
            this.m_PruningStrategy = value.getSelectedTag().getID();
        }
    }

    public SelectedTag getPruningStrategy() {
        return new SelectedTag(this.m_PruningStrategy, TAGS_PRUNING);
    }

    public String minNumObjTipText() {
        return "Set minimal number of instances at the terminal nodes.";
    }

    public void setMinNumObj(int value) {
        this.m_minNumObj = value;
    }

    public int getMinNumObj() {
        return this.m_minNumObj;
    }

    public String numFoldsPruningTipText() {
        return "Number of folds in internal cross-validation.";
    }

    public void setNumFoldsPruning(int value) {
        this.m_numFoldsPruning = value;
    }

    public int getNumFoldsPruning() {
        return this.m_numFoldsPruning;
    }

    public String heuristicTipText() {
        return "If heuristic search is used for binary split for nominal attributes.";
    }

    public void setHeuristic(boolean value) {
        this.m_Heuristic = value;
    }

    public boolean getHeuristic() {
        return this.m_Heuristic;
    }

    public String useGiniTipText() {
        return "If true the Gini index is used for splitting criterion, otherwise the information is used.";
    }

    public void setUseGini(boolean value) {
        this.m_UseGini = value;
    }

    public boolean getUseGini() {
        return this.m_UseGini;
    }

    public String useErrorRateTipText() {
        return "If error rate is used as error estimate. if not, root mean squared error is used.";
    }

    public void setUseErrorRate(boolean value) {
        this.m_UseErrorRate = value;
    }

    public boolean getUseErrorRate() {
        return this.m_UseErrorRate;
    }

    public String useOneSETipText() {
        return "Use the 1SE rule to make pruning decision.";
    }

    public void setUseOneSE(boolean value) {
        this.m_UseOneSE = value;
    }

    public boolean getUseOneSE() {
        return this.m_UseOneSE;
    }

    public String sizePerTipText() {
        return "The percentage of the training set size (0-1, 0 not included).";
    }

    public void setSizePer(double value) {
        if (value <= 0.0 || value > 1.0) {
            System.err.println("The percentage of the training set size must be in range 0 to 1 (0 not included) - ignored!");
        } else {
            this.m_SizePer = value;
        }
    }

    public double getSizePer() {
        return this.m_SizePer;
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 6947 $");
    }

    public static void main(String[] args) {
        BFTree.runClassifier(new BFTree(), args);
    }
}

