/*
 * Decompiled with CFR 0.152.
 */
package dmLab.gui.graphViewer;

import dmLab.array.functions.DiscFunctions;
import dmLab.experiment.ExperimentParams;
import dmLab.gui.dataEditor.windows.AboutWindow;
import dmLab.gui.graphViewer.GraphViewerInfo;
import dmLab.gui.graphViewer.components.GraphViewerMenu;
import dmLab.gui.graphViewer.components.GraphViewerToolBar;
import dmLab.gui.graphViewer.visualization.GraphVisualization;
import dmLab.mcfs.MCFSParams;
import dmLab.mcfs.attributesID.AttributesID;
import dmLab.mcfs.attributesID.DependencyLoader;
import dmLab.mcfs.attributesID.graph.GraphNode;
import dmLab.mcfs.attributesID.graph.IDGraph;
import dmLab.mcfs.attributesRI.AttributesRI;
import dmLab.mcfs.attributesRI.Ranking;
import dmLab.utils.fileFilters.ComplexFileFilter;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;

public final class GraphViewerBody
extends JFrame
implements ActionListener {
    private GraphViewerMenu menuBar;
    private JFileChooser fileDialog;
    private GraphViewerToolBar toolBar;
    private JScrollPane graphPane;
    private JSplitPane horizontalSplitPanel;
    public AttributesID connections;
    private IDGraph graph;
    public GraphVisualization graphVisualization = new GraphVisualization();
    private AboutWindow aboutWindow;
    public static int TOP_SET_MAX_SLIDER_VALUE = 500;

    public GraphViewerBody() {
        this.connections = new AttributesID(true, false);
        GraphViewerBody graphViewerBody = this;
        graphViewerBody.setTitle("dmLab - ID Graphs Viewer");
        graphViewerBody.initFileDialog();
        GraphViewerBody graphViewerBody2 = graphViewerBody;
        graphViewerBody.menuBar = new GraphViewerMenu();
        GraphViewerBody graphViewerBody3 = graphViewerBody2;
        GraphViewerMenu graphViewerMenu = graphViewerBody2.menuBar;
        graphViewerMenu.openFileMenuItem.addActionListener(graphViewerBody3);
        graphViewerMenu.saveFileMenuItem.addActionListener(graphViewerBody3);
        graphViewerMenu.closeFileMenuItem.addActionListener(graphViewerBody3);
        graphViewerMenu.exitMenuItem.addActionListener(graphViewerBody3);
        graphViewerMenu.aboutMenuItem.addActionListener(graphViewerBody3);
        graphViewerBody2.setJMenuBar(graphViewerBody2.menuBar);
        graphViewerBody2.menuBar.setPreferredSize(new Dimension(392, 18));
        graphViewerBody.setSize(800, 700);
        graphViewerBody.setLocation(200, 100);
        graphViewerBody.toolBar = new GraphViewerToolBar(graphViewerBody);
        graphViewerBody.horizontalSplitPanel = new JSplitPane();
        graphViewerBody.getContentPane().add((Component)graphViewerBody.horizontalSplitPanel, "Center");
        graphViewerBody.horizontalSplitPanel.setOrientation(0);
        graphViewerBody.horizontalSplitPanel.add((Component)graphViewerBody.toolBar, "top");
        graphViewerBody.toolBar.setPreferredSize(new Dimension(790, 100));
        graphViewerBody.drawGraph();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void actionPerformed(ActionEvent event) {
        void var1_1;
        Object eventObject = event.getSource();
        if (eventObject == this.menuBar.openFileMenuItem) {
            eventObject = this;
            int n = ((GraphViewerBody)eventObject).fileDialog.showOpenDialog((Component)eventObject);
            if (n != 1 && n == 0) {
                super.closeFile();
                Object object = ((GraphViewerBody)eventObject).fileDialog.getSelectedFile();
                System.out.println("Loading connections file: " + ((File)object).getAbsolutePath());
                String string = MCFSParams.getExperimentName(((File)object).getAbsolutePath());
                boolean bl = false;
                if (DiscFunctions.getFileExtension(((File)object).getName()).equalsIgnoreCase("csv")) {
                    String string2 = ((File)object).getAbsolutePath();
                    AttributesID attributesID = ((GraphViewerBody)eventObject).connections;
                    DependencyLoader dependencyLoader = new DependencyLoader();
                    bl = dependencyLoader.load(string2, attributesID);
                } else if (DiscFunctions.getFileExtension(((File)object).getName()).equalsIgnoreCase("xml")) {
                    bl = ((GraphViewerBody)eventObject).graphVisualization.loadGraph(((File)object).getAbsolutePath());
                }
                if (bl) {
                    System.out.println("Connections are loaded.");
                    ((Frame)eventObject).setTitle("dmLab - ID Graphs Viewer - " + ((File)object).getName());
                    ((GraphViewerBody)eventObject).connections.findMinMaxID();
                    object = new File(String.valueOf(string) + "_" + MCFSParams.FILESUFIX_RI);
                    System.out.println("Loading importances file: " + ((File)object).getAbsolutePath());
                    if (!((GraphViewerBody)eventObject).toolBar.loadImportanceFile((File)object)) {
                        System.out.println("Lading importances failed.");
                    }
                    ((GraphViewerBody)eventObject).toolBar.initWeightSlider(((GraphViewerBody)eventObject).connections);
                    ((GraphViewerBody)eventObject).toolBar.initTopSetSlider(((GraphViewerBody)eventObject).connections);
                    object = new Ranking();
                    File file = new File(String.valueOf(string) + MCFSParams.FILESUFIX_TOPRANKING);
                    System.out.println("Loading topRanking file: " + file.getAbsolutePath());
                    int n2 = ((GraphViewerBody)eventObject).connections.getNodesNumber();
                    float f = ((GraphViewerBody)eventObject).connections.getIDValue(20);
                    if (((GraphViewerBody)eventObject).toolBar.isImportanceLoaded()) {
                        if (((Ranking)object).load(file.getAbsolutePath())) {
                            n2 = ((Ranking)object).size();
                            ((GraphViewerBody)eventObject).graphVisualization.setMinImportanceValue(((Ranking)object).getWeight(((Ranking)object).size() - 1));
                        } else {
                            System.out.println("Lading topRanking failed.");
                            n2 = 20;
                        }
                        f = 0.0f;
                    }
                    ((GraphViewerBody)eventObject).toolBar.setTopRankingSize(n2, true);
                    ((GraphViewerBody)eventObject).toolBar.setConnectionWeight(f, true);
                    ((GraphViewerBody)eventObject).drawGraph();
                }
            }
            return;
        }
        if (eventObject == this.menuBar.saveFileMenuItem) {
            eventObject = this;
            int n = ((GraphViewerBody)eventObject).fileDialog.showSaveDialog((Component)eventObject);
            boolean bl = false;
            if (n != 1 && n == 0) {
                File file = ((GraphViewerBody)eventObject).fileDialog.getSelectedFile();
                String string = file.getAbsolutePath();
                if (((ComplexFileFilter)((GraphViewerBody)eventObject).fileDialog.getFileFilter()).accept("csv")) {
                    if (!DiscFunctions.getFileExtension(file.getName()).equalsIgnoreCase("csv")) {
                        string = String.valueOf(string) + ".csv";
                    }
                    System.out.println("Saving: " + string);
                    if (((GraphViewerBody)eventObject).connections.cut(((GraphViewerBody)eventObject).toolBar.getConnectionWeight(), ((GraphViewerBody)eventObject).toolBar.getAttributesImportance(), ((GraphViewerBody)eventObject).toolBar.getTopSetSize()).save(string)) {
                        bl = true;
                    }
                } else if (((ComplexFileFilter)((GraphViewerBody)eventObject).fileDialog.getFileFilter()).accept("xml")) {
                    if (!DiscFunctions.getFileExtension(file.getName()).equalsIgnoreCase("xml")) {
                        string = String.valueOf(string) + ".xml";
                    }
                    System.out.println("Saving: " + string);
                    if (((GraphViewerBody)eventObject).graphVisualization.saveGraph(string)) {
                        bl = true;
                    }
                } else if (DiscFunctions.getFileExtension(file.getName()).equalsIgnoreCase("csv")) {
                    System.out.println("Saving: " + string);
                    if (((GraphViewerBody)eventObject).connections.cut(((GraphViewerBody)eventObject).toolBar.getConnectionWeight(), ((GraphViewerBody)eventObject).toolBar.getAttributesImportance(), ((GraphViewerBody)eventObject).toolBar.getTopSetSize()).save(string)) {
                        bl = true;
                    }
                } else if (DiscFunctions.getFileExtension(file.getName()).equalsIgnoreCase("xml")) {
                    System.out.println("Saving: " + string);
                    if (((GraphViewerBody)eventObject).graphVisualization.saveGraph(string)) {
                        bl = true;
                    }
                }
                if (bl) {
                    System.out.println("File is saved.");
                }
            }
            return;
        }
        if (eventObject == this.menuBar.closeFileMenuItem) {
            this.closeFile();
            return;
        }
        if (eventObject == this.menuBar.exitMenuItem) {
            eventObject = this;
            ((Window)eventObject).dispose();
            return;
        }
        if (var1_1 == this.menuBar.aboutMenuItem) {
            if (this.aboutWindow == null) {
                this.aboutWindow = new AboutWindow(new GraphViewerInfo().toString());
            }
            this.aboutWindow.setVisible(true);
        }
    }

    public final void drawGraph() {
        if (this.connections.getNodesNumber() == 0) {
            this.graphPane = this.graphVisualization.getGraph() != null ? new JScrollPane((Component)this.graphVisualization.getGraph()) : new JScrollPane();
        } else {
            int n = this.toolBar.getTopSetSize();
            AttributesRI attributesRI = this.toolBar.getAttributesImportance();
            float f = this.toolBar.getConnectionWeight();
            Object object = this.connections;
            object = ((AttributesID)object).cut(f, attributesRI, n);
            object = ((AttributesID)object).toGraph();
            ((IDGraph)object).setNodesWeights(attributesRI);
            if (attributesRI != null) {
                float[] fArray = attributesRI.getMinMaxImportances(attributesRI.mainMeasureIdx);
                ((IDGraph)object).setMinNodeWeight(fArray[0]);
                ((IDGraph)object).setMaxNodeWeight(fArray[1]);
            } else {
                ((IDGraph)object).setMinNodeWeight(GraphNode.DEFAULT_WEIGHT);
                ((IDGraph)object).setMaxNodeWeight(GraphNode.DEFAULT_WEIGHT);
            }
            this.graph = object;
            this.graphVisualization.createGraph(this.graph);
            this.graphPane = new JScrollPane((Component)this.graphVisualization.getGraph());
        }
        this.horizontalSplitPanel.add((Component)this.graphPane, "bottom");
        this.graphPane.setPreferredSize(new Dimension(790, 500));
    }

    private void initFileDialog() {
        this.fileDialog = new JFileChooser(ExperimentParams.DEFAULT_RES_PATH);
        this.fileDialog.setLocation(100, 100);
        ComplexFileFilter[] fileFilters = new ComplexFileFilter[]{new ComplexFileFilter(new String[]{"connections.csv"}, "CSV Connections File"), new ComplexFileFilter(new String[]{"xml"}, "JGraph XML File")};
        int i = 0;
        while (i < 2) {
            this.fileDialog.addChoosableFileFilter(fileFilters[i]);
            ++i;
        }
        this.fileDialog.addChoosableFileFilter(new ComplexFileFilter(new String[]{"csv", "xml"}, "All Supported Files"));
    }

    private void closeFile() {
        if (this.connections.getNodesNumber() > 0 || this.graphVisualization.getGraph() != null) {
            System.out.println("Closing file");
            this.connections.init();
            System.out.println("File is closed.");
            this.setTitle("dmLab - ID Graphs Viewer");
            this.graphVisualization.clean();
            this.toolBar.cleanGUI();
            this.drawGraph();
        }
    }

    public final void run() {
        System.out.print(new GraphViewerInfo().toString());
        this.setVisible(true);
    }
}

