/*
 * Decompiled with CFR 0.152.
 */
package jdistlib;

import jdistlib.Binomial;
import jdistlib.generic.GenericDistribution;
import jdistlib.math.MathFunctions;
import jdistlib.rng.RandomEngine;

public class BetaBinomial
extends GenericDistribution {
    protected double mu;
    protected double sigma;
    protected int bd;

    public static final double density(double x, double mu, double sigma, double bd, boolean give_log) {
        if (Double.isNaN(x) || Double.isNaN(mu) || Double.isNaN(sigma) || Double.isNaN(bd)) {
            return x + mu + sigma + bd;
        }
        if (x < 0.0 || mu < 0.0 || mu > 1.0 || sigma <= 0.0 || bd < x) {
            return Double.NaN;
        }
        if (MathFunctions.isNonInt(x) || MathFunctions.isNonInt(bd)) {
            return give_log ? Double.NEGATIVE_INFINITY : 0.0;
        }
        x = Math.rint(x);
        double mu_sigma = mu / sigma;
        double mu_sigma_comp = (1.0 - mu) / sigma;
        double sigma_rec = 1.0 / sigma;
        double logfy = MathFunctions.lgammafn(bd + 1.0) - MathFunctions.lgammafn(x + 1.0) - MathFunctions.lgammafn(bd - x + 1.0) + MathFunctions.lgammafn(sigma_rec) + MathFunctions.lgammafn(x + mu_sigma) + MathFunctions.lgammafn(bd + mu_sigma_comp - x) - MathFunctions.lgammafn(mu_sigma) - MathFunctions.lgammafn(mu_sigma_comp) - MathFunctions.lgammafn(bd + sigma_rec);
        if (MathFunctions.isInfinite(logfy)) {
            logfy = Binomial.density(x, bd, mu, give_log);
        }
        return give_log ? logfy : Math.exp(logfy);
    }

    public static final double cumulative(double q, double mu, double sigma, double bd, boolean lower_tail, boolean log_p) {
        if (Double.isNaN(q) || Double.isNaN(mu) || Double.isNaN(sigma) || Double.isNaN(bd)) {
            return q + mu + sigma + bd;
        }
        if (q < 0.0 || mu < 0.0 || mu > 1.0 || sigma <= 0.0 || bd < q) {
            return Double.NaN;
        }
        if (MathFunctions.isNonInt(q) || MathFunctions.isNonInt(bd)) {
            return log_p ? Double.NEGATIVE_INFINITY : 0.0;
        }
        q = Math.rint(q);
        double sum = 0.0;
        int i = 0;
        while ((double)i <= q) {
            sum += BetaBinomial.density(i, mu, sigma, bd, false);
            ++i;
        }
        if (!lower_tail) {
            sum = 1.0 - sum;
        }
        if (log_p) {
            sum = Math.log(sum);
        }
        if (MathFunctions.isInfinite(sum)) {
            sum = Binomial.cumulative(q, bd, mu, lower_tail, log_p);
        }
        return sum;
    }

    public static final double quantile(double p, double mu, double sigma, double bd, boolean lower_tail, boolean log_p) {
        if (Double.isNaN(p) || Double.isNaN(mu) || Double.isNaN(sigma) || Double.isNaN(bd)) {
            return p + mu + sigma + bd;
        }
        if (p < 0.0 || p > 1.0 || mu < 0.0 || mu > 1.0 || sigma <= 0.0 || bd < 0.0) {
            return Double.NaN;
        }
        if (MathFunctions.isNonInt(bd)) {
            return log_p ? Double.NEGATIVE_INFINITY : 0.0;
        }
        if (log_p) {
            p = Math.exp(p);
        }
        if (!lower_tail) {
            p = 1.0 - p;
        }
        double sum = 0.0;
        int j = 0;
        while ((double)j <= bd) {
            if (p <= (sum += BetaBinomial.density(j, bd, mu, sigma, false))) {
                return j;
            }
            ++j;
        }
        return Double.NaN;
    }

    public static final double random(double mu, double sigma, double bd, RandomEngine random) {
        if (Double.isNaN(mu) || Double.isNaN(sigma) || Double.isNaN(bd)) {
            return mu + sigma + bd;
        }
        if (mu < 0.0 || mu > 1.0 || sigma <= 0.0 || bd < 0.0) {
            return Double.NaN;
        }
        double p = random.nextDouble();
        int j = 0;
        while ((double)j <= bd) {
            if (p <= BetaBinomial.cumulative(j, bd, mu, sigma, true, false)) {
                return j;
            }
            ++j;
        }
        return Double.NaN;
    }

    public static final double[] random(int n, double mu, double sigma, double bd, RandomEngine random) {
        double[] rand = new double[n];
        int i = 0;
        while (i < n) {
            rand[i] = BetaBinomial.random(mu, sigma, bd, random);
            ++i;
        }
        return rand;
    }

    public BetaBinomial(double mu, double sigma, int bd) {
        this.mu = mu;
        this.sigma = sigma;
        this.bd = bd;
    }

    public double density(double x, boolean log) {
        return BetaBinomial.density(x, this.mu, this.sigma, this.bd, log);
    }

    public double cumulative(double p, boolean lower_tail, boolean log_p) {
        return BetaBinomial.cumulative(p, this.mu, this.sigma, this.bd, lower_tail, log_p);
    }

    public double quantile(double q, boolean lower_tail, boolean log_p) {
        return BetaBinomial.quantile(q, this.mu, this.sigma, this.bd, lower_tail, log_p);
    }

    public double random() {
        return BetaBinomial.random(this.mu, this.sigma, this.bd, this.random);
    }
}

