/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.trees.j48;

import weka.classifiers.trees.j48.Distribution;
import weka.classifiers.trees.j48.EntropyBasedSplitCrit;
import weka.core.RevisionUtils;
import weka.core.Utils;

public final class GainRatioSplitCrit
extends EntropyBasedSplitCrit {
    private static final long serialVersionUID = -433336694718670930L;

    @Override
    public final double splitCritValue(Distribution bags) {
        double numerator = this.oldEnt(bags) - this.newEnt(bags);
        if (Utils.eq(numerator, 0.0)) {
            return Double.MAX_VALUE;
        }
        double denumerator = this.splitEnt(bags);
        if (Utils.eq(denumerator, 0.0)) {
            return Double.MAX_VALUE;
        }
        return denumerator / numerator;
    }

    public final double splitCritValue(Distribution bags, double totalnoInst, double numerator) {
        double denumerator = this.splitEnt(bags, totalnoInst);
        if (Utils.eq(denumerator, 0.0)) {
            return 0.0;
        }
        return numerator / (denumerator /= totalnoInst);
    }

    private final double splitEnt(Distribution bags, double totalnoInst) {
        double returnValue = 0.0;
        double noUnknown = totalnoInst - bags.total();
        if (Utils.gr(bags.total(), 0.0)) {
            int i = 0;
            while (i < bags.numBags()) {
                returnValue -= this.logFunc(bags.perBag(i));
                ++i;
            }
            returnValue -= this.logFunc(noUnknown);
            returnValue += this.logFunc(totalnoInst);
        }
        return returnValue;
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 1.8 $");
    }
}

