% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pandoc.R
\name{pandoc_args}
\alias{pandoc_args}
\alias{pandoc_variable_arg}
\alias{pandoc_include_args}
\alias{pandoc_highlight_args}
\alias{pandoc_latex_engine_args}
\alias{pandoc_toc_args}
\title{Functions for generating pandoc command line arguments}
\usage{
pandoc_variable_arg(name, value)

pandoc_include_args(in_header = NULL, before_body = NULL,
  after_body = NULL)

pandoc_highlight_args(highlight, default = "tango")

pandoc_latex_engine_args(latex_engine)

pandoc_toc_args(toc, toc_depth = 3)
}
\arguments{
\item{name}{Name of template variable to set.}

\item{value}{Value of template variable.}

\item{in_header}{One or more files with content to be included in the
header of the document.}

\item{before_body}{One or more files with content to be included before
the document body.}

\item{after_body}{One or more files with content to be included after the
document body.}

\item{highlight}{The name of a pandoc syntax highlighting theme.}

\item{default}{The highlighting theme to use if "default"
is specified.}

\item{latex_engine}{LaTeX engine for producing PDF output. Options are
"pdflatex", "lualatex", and "xelatex".}

\item{toc}{\code{TRUE} to include a table of contents in the output.}

\item{toc_depth}{Depth of headers to include in table of contents.}
}
\value{
A character vector with pandoc command line arguments
}
\description{
Functions that assist in creating various types of pandoc command line
arguments (e.g. for templates, table of contents, highlighting, and content
includes)
}
\details{
Non-absolute paths for resources referenced from the
  \code{in_header}, \code{before_body}, and \code{after_body}
  parameters are resolved relative to the directory of the input document.
}
\examples{
\dontrun{

library(rmarkdown)

pandoc_include_args(before_body = "header.htm")
pandoc_include_args(before_body = "header.tex")

pancoc_highlight_args("kate")

pandoc_latex_engine_args("pdflatex")

pandoc_toc_args(toc = TRUE, toc_depth = 2)

}
}
