% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clip_erase.R
\name{ms_clip}
\alias{ms_clip}
\title{Remove features or portions of features that fall outside a clipping area.}
\usage{
ms_clip(target, clip = NULL, bbox = NULL, remove_slivers = FALSE,
  force_FC = TRUE, sys = FALSE)
}
\arguments{
\item{target}{the target layer from which to remove portions. One of:
\itemize{
\item \code{geo_json} or \code{character} points, lines, or polygons;
\item \code{geo_list} points, lines, or polygons;
\item \code{SpatialPolygons}, \code{SpatialLines}, \code{SpatialPoints};
\item \code{sf} or \code{sfc} points, lines, or polygons object
}}

\item{clip}{the clipping layer (polygon). One of:
\itemize{
\item \code{geo_json} or \code{character} polygons;
\item \code{geo_list} polygons;
\item \code{SpatialPolygons*};
\item \code{sf} or \code{sfc} polygons object
}}

\item{bbox}{supply a bounding box instead of a clipping layer to extract from
the target layer. Supply as a numeric vector: \code{c(minX, minY, maxX, maxY)}.}

\item{remove_slivers}{Remove tiny sliver polygons created by clipping. (Default \code{FALSE})}

\item{force_FC}{should the output be forced to be a \code{FeatureCollection} even
if there are no attributes? Default \code{TRUE}.
\code{FeatureCollections} are more compatible with \code{rgdal::readOGR} and
\code{geojsonio::geojson_sp}. If \code{FALSE} and there are no attributes associated with
the geometries, a \code{GeometryCollection} will be output. Ignored for \code{Spatial}
objects, as the output is always the same as the input.}

\item{sys}{Should the system mapshaper be used instead of the bundled mapshaper? Gives
better performance on large files. Requires the mapshaper node package to be installed
and on the PATH.}
}
\value{
clipped target in the same class as the input target
}
\description{
Removes portions of the target layer that fall outside the clipping layer or bounding box.
}
\examples{
library(geojsonio, quietly = TRUE)
library(sp)

poly <- structure("{\\"type\\":\\"FeatureCollection\\",
  \\"features\\":[{\\"type\\":\\"Feature\\",\\"properties\\":{},
  \\"geometry\\":{\\"type\\":\\"Polygon\\",\\"coordinates\\":
  [[[52.8658,-44.7219],[53.7702,-40.4873],[55.3204,-37.5579],
  [56.2757,-37.917],[56.184,-40.6443],[61.0835,-40.7529],
  [58.0202,-43.634],[61.6699,-45.0678],[62.737,-46.2841],
  [55.7763,-46.2637],[54.9742,-49.1184],[52.799,-45.9386],
  [52.0329,-49.5677],[50.1747,-52.1814],[49.0098,-52.3641],
  [52.7068,-45.7639],[43.2278,-47.1908],[48.4755,-45.1388],
  [50.327,-43.5207],[48.0804,-41.2784],[49.6307,-40.6159],
  [52.8658,-44.7219]]]}}]}", class = c("json", "geo_json"))
poly <- geojson_sp(poly)
plot(poly)

clip_poly <- structure('{
"type": "Feature",
"properties": {},
"geometry": {
"type": "Polygon",
"coordinates": [
[
[51, -40],
[55, -40],
[55, -45],
[51, -45],
[51, -40]
]
]
}
}', class = c("json", "geo_json"))
clip_poly <- geojson_sp(clip_poly)
plot(clip_poly)

out <- ms_clip(poly, clip_poly)
plot(out, add = TRUE)

}
