% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inner_lines.R
\name{ms_innerlines}
\alias{ms_innerlines}
\title{Create a line layer consisting of shared boundaries with no attribute data}
\usage{
ms_innerlines(input, force_FC = TRUE)
}
\arguments{
\item{input}{input polygons object to convert to inner lines. One of:
\itemize{
 \item \code{geo_json} or \code{character} polygons;
 \item \code{geo_list} polygons;
 \item \code{SpatialPolygons*};
 \item \code{sf} or \code{sfc} polygons object
 }}

\item{force_FC}{should the output be forced to be a \code{FeatureCollection}
even if there are no attributes? Default \code{TRUE}.
\code{FeatureCollections} are more compatible with \code{rgdal::readOGR}
and \code{geojsonio::geojson_sp}. If \code{FALSE} and there are no
attributes associated with the geometries, a \code{GeometryCollection} will
be output. Ignored for \code{Spatial} objects.}
}
\value{
lines in the same class as the input layer, but without attributes
}
\description{
Create a line layer consisting of shared boundaries with no attribute data
}
\examples{
library(geojsonio)
library(sp)

poly <- structure('{"type":"FeatureCollection",
            "features":[
              {"type":"Feature",
                "properties":{"foo": "a"},
                "geometry":{"type":"Polygon","coordinates":[[
                  [102,2],[102,3],[103,3],[103,2],[102,2]
                  ]]}}
              ,{"type":"Feature",
                "properties":{"foo": "a"},
                "geometry":{"type":"Polygon","coordinates":[[
                  [103,3],[104,3],[104,2],[103,2],[103,3]
                  ]]}},
              {"type":"Feature",
                "properties":{"foo": "b"},
                "geometry":{"type":"Polygon","coordinates":[[
                  [102,1],[102,2],[103,2],[103,1],[102,1]
                  ]]}},
              {"type":"Feature",
                "properties":{"foo": "b"},
                "geometry":{"type":"Polygon","coordinates":[[
                  [103,1],[103,2],[104,2],[104,1],[103,1]
                  ]]}}]}', class = c("json", "geo_json"))

poly <- geojson_sp(poly)
plot(poly)

out <- ms_innerlines(poly)
plot(out)

}
