#' Run `make` in the system
#'
#' This function executes the `make` command to rebuild all dependencies according to the `Makefile`
#' generated by [makefile()].
#'
#' @param ... Command-line arguments passed to the `make` command
#'     (see `?make` in your shell for details)
#' @param .stdout Where to direct standard output; see [base::system2()].
#' @param .stderr Where to direct standard error; see [base::system2()].
#' @param .stdin Where to get standard input; see [base::system2()]
#' @return Exit status of the command; see [base::system2()] for details.
#' @seealso [makefile()], [rmakeSkeleton()]
#' @author Michal Burda
#' @examples
#' \dontrun{
#'   make()        # make all
#'   make('clean') # make the 'clean' task
#'   make('-j', 4) # make with 4 processes in parallel
#' }
#' @export
make <- function(..., .stdout = "", .stderr = "", .stdin = "") {
  args <- as.character(c(...))
  system2('make', args=args, stdout = .stdout, stderr = .stderr, stdin = .stdin)
}
