% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rlo_table.R
\name{rlo_table}
\alias{rlo_table}
\title{Insert a table into the connected document}
\usage{
rlo_table(x, captiontext, header = "colnames", group_header = NULL,
  common_header = NULL, group_sizes = NULL, footer = NULL,
  factors = NULL, merge_index = NULL, numbered = TRUE, NA_string = "",
  break_before_caption = FALSE, split = FALSE, repeat_headlines = TRUE,
  charheight = NULL, widths = NULL, warn = FALSE)
}
\arguments{
\item{x}{A matrix of character vectors to be inserted as a table. If not a matrix,
an attempt is made to turn it into a matrix by \code{\link{as.matrix}}.}

\item{captiontext}{The text of the caption}

\item{header}{The names to be used for the columns of the matrix}

\item{group_header}{If not NULL, the names of column groups}

\item{common_header}{If not NULL, the common header of all matrix columns}

\item{group_sizes}{If group_header is not NULL, a vector holding the sizes of
column groups}

\item{footer}{An optional text to be included as a table footer}

\item{factors}{An optional named list of character vectors that must describe the
rows of the matrix object}

\item{merge_index}{An optional character vector with the names of the factors for
which adjacent cells with identical values should be merged}

\item{numbered}{Should the caption of the table be numbered?}

\item{NA_string}{The string used for NA values}

\item{break_before_caption}{Should a page break be insersted before the caption}

\item{split}{Should it be allowed to split the table across pages}

\item{repeat_headlines}{Should the headline(s) be repeated?}

\item{charheight}{An optional way to specify the character height in table cells}

\item{widths}{An optional way to specify relative columns widths}

\item{warn}{Should missing paragraph styles give a warning?}
}
\description{
Inserts a table at the current position of the view cursor.
}

