% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{deg.pw}
\alias{deg.pw}
\title{Data frame for example pairwise DEG test result}
\format{
data.frame object of 1000 rows with columns:
\itemize{
\item feature: gene names.
\item group: class name within the variable being used for the test condition.
\item logFC: log fold change of the gene expression between the condition of
interest against the control condition.
\item pval: p-value of the DEG test.
\item padj: adjusted p-value of the DEG test.
\item pct_in: percentage of cells in the condition of interest expressing the
gene.
\item pct_out: percentage of cells in the control condition expressing the
gene.
}
}
\usage{
deg.pw
}
\description{
The data frame is the direct output of pairwise DEG test applied on example
dataset which can be loaded with \code{importPBMC()}. Cell type annotation
was obtained from SeuratData package, "ifnb" dataset, since they are the
same. Use the following command to reproduce the same result:

\if{html}{\out{<div class="sourceCode">}}\preformatted{library(rliger)
library(Seurat)
library(SeuratData)

lig <- importPBMC()
ifnb <- LoadData("ifnb")
lig$cell_type <- ifnb$seurat_annotations
lig$condition_cell_type <- interaction(lig$dataset, lig$cell_type, drop = FALSE)
deg.pw <- runPairwiseDEG(
    object = lig,
    groupTest = 'stim.CD14 Mono',
    groupCtrl = 'ctrl.CD14 Mono',
    variable1 = 'condition_cell_type'
)
deg.pw <- deg.pw[order(deg.pw$padj)[1:1000],]
```

The result represents the statistics of DEG test between stim dataset against
ctrl dataset, within the CD14 monocytes. The result is randomly sampled to
1000 entries for minimum demonstration.

[1:1000]: R:1:1000
}\if{html}{\out{</div>}}
}
\seealso{
\code{\link[=runPairwiseDEG]{runPairwiseDEG()}}
}
\keyword{datasets}
