% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/integration.R
\name{centroidAlign}
\alias{centroidAlign}
\alias{centroidAlign.liger}
\alias{centroidAlign.Seurat}
\title{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}} Align factor loading by centroid alignment (beta)}
\usage{
centroidAlign(object, ...)

\method{centroidAlign}{liger}(
  object,
  lambda = 1,
  useDims = NULL,
  scaleEmb = TRUE,
  centerEmb = TRUE,
  scaleCluster = FALSE,
  centerCluster = FALSE,
  shift = FALSE,
  diagnosis = FALSE,
  ...
)

\method{centroidAlign}{Seurat}(
  object,
  reduction = "inmf",
  lambda = 1,
  useDims = NULL,
  scaleEmb = TRUE,
  centerEmb = TRUE,
  scaleCluster = FALSE,
  centerCluster = FALSE,
  shift = FALSE,
  diagnosis = FALSE,
  ...
)
}
\arguments{
\item{object}{A \linkS4class{liger} or Seurat object with valid factorization
result available (i.e. \code{\link{runIntegration}} performed in advance).}

\item{...}{Arguments passed to other S3 methods of this function.}

\item{lambda}{Ridge regression penalty applied to each dataset. Can be one
number that applies to all datasets, or a numeric vector with length equal to
the number of datasets. Default \code{1}.}

\item{useDims}{Indices of factors to use considered for the alignment.
Default \code{NULL} uses all factors.}

\item{scaleEmb}{Logical, whether to scale the factor loading being considered
as the embedding. Default \code{TRUE}.}

\item{centerEmb}{Logical, whether to center the factor loading being
considered as the embedding before scaling it. Default \code{TRUE}.}

\item{scaleCluster}{Logical, whether to scale the factor loading being
considered as the cluster assignment probability. Default \code{FALSE}.}

\item{centerCluster}{Logical, whether to center the factor loading being
considered as the cluster assignment probability before scaling it. Default
\code{FALSE}.}

\item{shift}{Logical, whether to shift the factor loading being considered as
the cluster assignment probability after centered scaling. Default
\code{FALSE}.}

\item{diagnosis}{Logical, whether to return cell metadata variables with
diagnostic information. See Details. Default \code{FALSE}.}

\item{reduction}{Name of the reduction where LIGER integration result is
stored. Default \code{"inmf"}.}
}
\value{
Returns the updated input object
\itemize{
\item{liger method
\itemize{
\item{Update the \code{H.norm} slot for the aligned cell factor
loading, ready for running graph based community detection clustering
or dimensionality reduction for visualization.}
\item{Update the \code{cellMata} slot with diagnostic information if
\code{diagnosis = TRUE}.}
}}
\item{Seurat method
\itemize{
\item{Update the \code{reductions} slot with a new \code{DimReduc}
object containing the aligned cell factor loading.}
\item{Update the metadata with diagnostic information if
\code{diagnosis = TRUE}.}
}}
}
}
\description{
This process treats the factor loading of each dataset as the low dimensional
embedding as well as the cluster assignment probability, i.e. the soft
clustering result. Then the method aligns the embedding by linearly moving
the centroids of the same cluster but within each dataset towards each other.

\bold{ATTENTION: This method is still under development while has shown
encouraging results in benchmarking tests. The arguments and their default
values reflect the best scored parameters in the tests and some of them may
be subject to change in the future.}
}
\details{
Diagnostic information include:

\itemize{
\item{object$raw_which.max: The index of the factor with the maximum value
in the raw factor loading.}
\item{object$R_which.max: The index of the factor with the maximum value in
the soft clustering probability matrix used for correction.}
\item{object$Z_which.max: The index of the factor with the maximum value in
the aligned factor loading.}
}
}
\examples{
pbmc <- centroidAlign(pbmcPlot)
}
