% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DoubletFinder.R
\name{runDoubletFinder}
\alias{runDoubletFinder}
\title{Doublet detection with DoubletFinder}
\usage{
runDoubletFinder(
  object,
  useDatasets = NULL,
  PCs = 1:10,
  nNeighbors = 20,
  nExp = NULL,
  verbose = getOption("ligerVerbose", TRUE),
  ...
)
}
\arguments{
\item{object}{A \linkS4class{liger} object.}

\item{useDatasets}{A character vector of the names, a numeric or logical
vector of the index of the datasets to run
\code{DoubletFinder::doubletFinder} with. Default \code{NULL}
applies to all datasets.}

\item{PCs}{Specific principal components to use. Default \code{1:10}.}

\item{nNeighbors}{Number of the PC neighborhood size used to compute pANN.
See "See Also". Scalar for all used datasets or vector for each. Default
\code{20}.}

\item{nExp}{The total number of doublet predictions produced. Scalar for all
used datasets or vector for each. Default \code{NULL} sets a 0.15 proportion.}

\item{verbose}{Logical. Whether to show information of the progress. Default
\code{getOption("ligerVerbose")} or \code{TRUE} if users have not set.}

\item{...}{Additional arguments passed to
\code{DoubletFinder::doubletFinder}.}
}
\value{
Updated \code{object} with variables \code{DoubletFinder_pANN} and
\code{DoubletFinder_classification} updated in \code{cellMeta} slot
}
\description{
Detect doublet with DoubletFinder. Package "Seurat" and
"DoubletFinder" would be required to run this function.

This wrapper runs Seurat PCA workflow (NormalizeData,
FindVariableFeatures, ScaleData, RunPCA) with all default settings on each
dataset, and then calls \code{DoubletFinder::doubletFinder}. Users that
prefer having more control on the preprocessing part might consider creating
single-sample Seurat object with
\code{CreateSeuratObject(rawData(object, "datasetName"))}.
}
\examples{
if (requireNamespace("DoubletFinder", quietly = TRUE)) {
    pbmc <- runDoubletFinder(pbmc)
    print(cellMeta(pbmc))
}
}
