% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ATAC.R
\name{imputeKNN}
\alias{imputeKNN}
\title{Impute the peak counts from gene expression data referring to an ATAC dataset
after integration}
\usage{
imputeKNN(
  object,
  reference,
  queries = NULL,
  nNeighbors = 20,
  weight = TRUE,
  norm = TRUE,
  scale = FALSE,
  verbose = getOption("ligerVerbose", TRUE),
  ...,
  knn_k = nNeighbors
)
}
\arguments{
\item{object}{\linkS4class{liger} object with aligned factor loading computed
in advance.}

\item{reference}{Name of a dataset containing peak data to impute into query
dataset(s).}

\item{queries}{Names of datasets to be augmented by imputation. Should not
include \code{reference}. Default \code{NULL} uses all datasets except the
reference.}

\item{nNeighbors}{The maximum number of nearest neighbors to search. Default
\code{20}.}

\item{weight}{Logical. Whether to use KNN distances as weight matrix. Default
\code{FALSE}.}

\item{norm}{Logical. Whether to normalize the imputed data. Default
\code{TRUE}.}

\item{scale}{Logical. Whether to scale but not center the imputed data.
Default \code{TRUE}.}

\item{verbose}{Logical. Whether to show information of the progress. Default
\code{getOption("ligerVerbose")} or \code{TRUE} if users have not set.}

\item{...}{Optional arguments to be passed to \code{\link{normalize}} when
\code{norm = TRUE}.}

\item{knn_k}{\bold{Deprecated}. See Usage section for replacement.}
}
\value{
The input \code{object} where queried \linkS4class{ligerDataset}
objects in \code{datasets} slot are replaced. These datasets will all be
converted to \linkS4class{ligerATACDataset} class with an additional slot
\code{rawPeak} to store the imputed peak counts, and \code{normPeak} for
normalized imputed peak counts if \code{norm = TRUE}.
}
\description{
This function is designed for creating peak data for a dataset with only gene
expression. This function uses aligned cell factor loading to find nearest
neighbors between cells from the queried dataset (without peak) and cells
from reference dataset (with peak). And then impute the peak for the former
basing on the weight. Therefore, the reference dataset selected must be of
"atac" modality setting.
}
\examples{
bmmc <- normalize(bmmc)
bmmc <- selectGenes(bmmc, datasets.use = "rna")
bmmc <- scaleNotCenter(bmmc)
if (requireNamespace("RcppPlanc", quietly = TRUE)) {
    bmmc <- runINMF(bmmc, k = 20)
    bmmc <- alignFactors(bmmc)
    bmmc <- normalizePeak(bmmc)
    bmmc <- imputeKNN(bmmc, reference = "atac", queries = "rna")
}
}
