% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preprocess.R
\name{runGeneralQC}
\alias{runGeneralQC}
\title{General QC for liger object}
\usage{
runGeneralQC(
  object,
  mito = TRUE,
  ribo = TRUE,
  hemo = TRUE,
  features = NULL,
  pattern = NULL,
  useDatasets = NULL,
  chunkSize = 1000,
  verbose = getOption("ligerVerbose", TRUE)
)
}
\arguments{
\item{object}{\linkS4class{liger} object with \code{rawData} available in
each \linkS4class{ligerDataset} embedded}

\item{mito, ribo, hemo}{Whether to calculate the expression percentage of
mitochondrial, ribosomal or hemoglobin genes, respectively. Default
\code{TRUE}.}

\item{features}{Feature names matching the feature subsets that users want to
calculate the expression percentage with. A vector for a single subset, or a
named list for multiple subset. Default \code{NULL}.}

\item{pattern}{Regex patterns for matching the feature subsets that users
want to calculate the expression percentage with. A vector for a single
subset, or a named list for multiple subset. Default \code{NULL}.}

\item{useDatasets}{A character vector of the names, a numeric or logical
vector of the index of the datasets to be included for QC. Default
\code{NULL} performs QC on all datasets.}

\item{chunkSize}{Integer number of cells to include in a chunk when working
on HDF5 based dataset. Default \code{1000}}

\item{verbose}{Logical. Whether to show information of the progress. Default
\code{getOption("ligerVerbose")} or \code{TRUE} if users have not set.}
}
\value{
Updated \code{object} with \code{nUMI}, \code{nGene} updated
in \code{cellMeta(object)}, as well as expression percentage value for each
feature subset.
}
\description{
Calculate number of UMIs, number of detected features and
percentage of feature subset (e.g. mito) expression per cell.
}
\examples{
pbmc <- runGeneralQC(pbmc)
}
