% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DEG_marker.R
\name{runPairwiseDEG}
\alias{runPairwiseDEG}
\alias{runMarkerDEG}
\alias{runWilcoxon}
\title{Find DEG between two groups}
\usage{
runPairwiseDEG(
  object,
  groupTest,
  groupCtrl,
  variable1 = NULL,
  variable2 = NULL,
  method = c("wilcoxon", "pseudoBulk"),
  usePeak = FALSE,
  useReplicate = NULL,
  nPsdRep = 5,
  minCellPerRep = 10,
  seed = 1,
  verbose = getOption("ligerVerbose", TRUE)
)

runMarkerDEG(
  object,
  conditionBy = NULL,
  splitBy = NULL,
  method = c("wilcoxon", "pseudoBulk"),
  useDatasets = NULL,
  usePeak = FALSE,
  useReplicate = NULL,
  nPsdRep = 5,
  minCellPerRep = 10,
  seed = 1,
  verbose = getOption("ligerVerbose", TRUE)
)

runWilcoxon(
  object,
  data.use = NULL,
  compare.method = c("clusters", "datasets")
)
}
\arguments{
\item{object}{A \linkS4class{liger} object, with normalized data available}

\item{groupTest, groupCtrl, variable1, variable2}{Condition specification. See
\code{?runPairwiseDEG} section \bold{Pairwise DEG Scenarios} for detail.}

\item{method}{DEG test method to use. Choose from \code{"wilcoxon"} or
\code{"pseudoBulk"}. Default \code{"wilcoxon"}}

\item{usePeak}{Logical. Whether to use peak count instead of gene count.
Only supported when ATAC datasets are involved. Default \code{FALSE}.}

\item{useReplicate}{\code{cellMeta} variable of biological replicate
annotation. Only used with \code{method = "pseudoBulk"}. Default \code{NULL}
will create \code{nPsdRep} pseudo replicates per group.}

\item{nPsdRep}{Number of pseudo replicates to create. Only used when
\code{method = "pseudoBulk", useReplicate = NULL}. Default \code{5}.}

\item{minCellPerRep}{Numeric, will not make pseudo-bulk for replicate with
less than this number of cells. Default \code{10}.}

\item{seed}{Random seed to use for pseudo-replicate generation. Default
\code{1}.}

\item{verbose}{Logical. Whether to show information of the progress. Default
\code{getOption("ligerVerbose")} or \code{TRUE} if users have not set.}

\item{conditionBy}{\code{cellMeta} variable(s). Marker detection will be
performed for each level of this variable. Multiple variables will be
combined. Default \code{NULL} uses default cluster.}

\item{splitBy}{Split data by \code{cellMeta} variable(s) here and identify
markers for \code{conditionBy} within each chunk. Default \code{NULL}.}

\item{useDatasets}{Datasets to perform marker detection within. Default
\code{NULL} will use all datasets.}

\item{data.use}{Same as \code{useDatasets}.}

\item{compare.method}{Choose from \code{"clusters"} (default) or
\code{"datasets"}. \code{"clusters"} compares each cluster against all other
cells, while \code{"datasets"} run within each cluster and compare each
dataset against all other datasets.}
}
\value{
A data.frame with DEG information
}
\description{
Find DEG between two groups. Two methods are supported:
\code{"wilcoxon"} and \code{"pseudoBulk"}. Wilcoxon rank sum test is
performed on single-cell level, while pseudo-bulk method aggregates cells
basing on biological replicates and calls bulk RNAseq DE methods, DESeq2 wald
test. When real biological replicates are not available, pseudo replicates
can be generated. Please see below for detailed scenario usage.
}
\section{Pairwise DEG Scenarios}{

Users can select classes of cells from a variable in \code{cellMeta}.
\code{variable1} and \code{variable2} are used to specify a column in
\code{cellMeta}, and \code{groupTest} and \code{groupCtrl} are used to specify
existing classes from \code{variable1} and \code{variable2}, respectively.
When \code{variable2} is missing, \code{groupCtrl} will be considered from
\code{variable1}.

For example, when \code{variable1 = "celltype"} and \code{variable2 = NULL},
\code{groupTest} and \code{groupCtrl} should be valid cell types in
\code{object$celltype}.

When \code{variable1} is "celltype" and \code{variable2} is "gender",
\code{groupTest} should be a valid cell type from \code{object$celltype} and
\code{groupCtrl} should be a valid class from \code{object$gender}.

When both \code{variable1} and \code{variable2} are missing, \code{groupTest}
and \code{groupCtrl} should be valid index of cells in \code{object}.
}

\section{Marker Detection Scenarios}{

Marker detection is generally performed in a one vs. rest manner. The
grouping of such condition is specified by \code{conditionBy}, which should
be a column name in \code{cellMeta}. When \code{splitBy} is specified as
another variable name in \code{cellMeta}, the marker detection will be
iteratively done for within each level of \code{splitBy} variable.

For example, when \code{conditionBy = "celltype"} and \code{splitBy = NULL},
marker detection will be performed by comparing all cells of "celltype_i"
against all other cells, and etc.

When \code{conditionBy = "celltype"} and \code{splitBy = "gender"}, marker
detection will be performed by comparing "celltype_i" cells from "gender_j"
against other cells from "gender_j", and etc.
}

\examples{
# Compare between cluster "0" and cluster "1"
degStats <- runPairwiseDEG(pbmcPlot, groupTest = 0, groupCtrl = 1,
                           variable1 = "leiden_cluster")
# Compare between all cells from cluster "5" and
# all cells from dataset "stim"
degStats <- runPairwiseDEG(pbmcPlot, groupTest = "5", groupCtrl = "stim",
                           variable1 = "leiden_cluster",
                           variable2 = "dataset")
# Identify markers for each cluster. Equivalent to old version
# `runWilcoxon(method = "cluster")`
markerStats <- runMarkerDEG(pbmcPlot, conditionBy = "leiden_cluster")
# Identify dataset markers within each cluster. Equivalent to old version
# `runWilcoxon(method = "dataset")`.
markerStatsList <- runMarkerDEG(pbmcPlot, conditionBy = "dataset",
                                splitBy = "leiden_cluster")
}
