% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rliger.R
\name{optimizeNewLambda}
\alias{optimizeNewLambda}
\title{Perform factorization for new lambda value}
\usage{
optimizeNewLambda(
  object,
  new.lambda,
  thresh = 1e-04,
  max.iters = 100,
  rand.seed = 1,
  verbose = TRUE
)
}
\arguments{
\item{object}{\code{liger} object. Should call optimizeALS before calling.}

\item{new.lambda}{Regularization parameter. Larger values penalize dataset-specific effects more
strongly.}

\item{thresh}{Convergence threshold. Convergence occurs when |obj0-obj|/(mean(obj0,obj)) < thresh}

\item{max.iters}{Maximum number of block coordinate descent iterations to perform (default 100).}

\item{rand.seed}{Random seed for reproducibility (default 1).}

\item{verbose}{Print progress bar/messages (TRUE by default)}
}
\value{
\code{liger} object with optimized factorization values
}
\description{
Uses an efficient strategy for updating that takes advantage of the information in the existing
factorization; uses previous k. Recommended mainly when re-optimizing for higher lambda and when
new lambda value is significantly different; otherwise may not return optimal results.
}
\examples{
ligerex <- createLiger(list(ctrl = ctrl, stim = stim))
ligerex <- normalize(ligerex)
ligerex <- selectGenes(ligerex)
ligerex <- scaleNotCenter(ligerex)
\donttest{
# Assume we are performing the factorization
# Specification for minimal example run time, not converging.
ligerex <- optimizeALS(ligerex, k = 5, lambda = 5, max.iters = 1)
# decide to run with lambda = 15 instead (keeping k the same)
ligerex <- optimizeNewLambda(ligerex, new.lambda = 15, max.iters = 1)
}
}
