% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rliger.R
\name{ligerToSeurat}
\alias{ligerToSeurat}
\title{Create a Seurat object containing the data from a liger object}
\usage{
ligerToSeurat(
  object,
  nms = NULL,
  renormalize = FALSE,
  use.liger.genes = TRUE,
  by.dataset = FALSE,
  assay = "RNA"
)
}
\arguments{
\item{object}{\code{liger} object.}

\item{nms}{By default, labels cell names with dataset of origin (this is to account for cells in
different datasets which may have same name). Other names can be passed here as vector, must
have same length as the number of datasets. (default names(H))}

\item{renormalize}{Whether to log-normalize raw data using Seurat defaults (default FALSE).}

\item{use.liger.genes}{Whether to carry over variable genes (default TRUE).}

\item{by.dataset}{Include dataset of origin in cluster identity in Seurat object (default FALSE).}

\item{assay}{Assay name to set in the Seurat object (default "RNA").}
}
\value{
Seurat object with raw.data, scale.data, dr$tsne, dr$inmf, and ident slots set.
}
\description{
Merges raw.data and scale.data of object, and creates Seurat object with these values along with
tsne.coords, iNMF factorization, and cluster assignments. Supports Seurat V2 and V3.
}
\details{
Stores original dataset identity by default in new object metadata if dataset names are passed
in nms. iNMF factorization is stored in dim.reduction object with key "iNMF".
}
\examples{
ligerex <- createLiger(list(ctrl = ctrl, stim = stim))
if (packageVersion("Matrix") <= package_version("1.6.1.1")) {
  # 1.6.2 is not compatible thus don't test
  # but can use `setOldClass("mMatrix")` as a hack
  srt <- ligerToSeurat(ligerex)
}
}
