% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rliger.R
\name{calcAgreement}
\alias{calcAgreement}
\title{Calculate agreement metric}
\usage{
calcAgreement(
  object,
  dr.method = "NMF",
  ndims = 40,
  k = 15,
  use.aligned = TRUE,
  rand.seed = 42,
  by.dataset = FALSE
)
}
\arguments{
\item{object}{\code{liger} object. Should call quantile_norm before calling.}

\item{dr.method}{Dimensionality reduction method to use for assessing pre-alignment geometry
(either "PCA", "NMF", or "ICA"). (default "NMF")}

\item{ndims}{Number of dimensions to use in dimensionality reduction (recommended to use the
same as number of factors) (default 40).}

\item{k}{Number of nearest neighbors to use in calculating Jaccard index (default 15).}

\item{use.aligned}{Whether to use quantile aligned or unaligned cell factor loadings (default
TRUE).}

\item{rand.seed}{Random seed for reproducibility (default 42).}

\item{by.dataset}{Return agreement calculated for each dataset (default FALSE).}
}
\value{
Agreement metric (or vector of agreement per dataset).
}
\description{
This metric quantifies how much the factorization and alignment distorts the geometry of the
original datasets. The greater the agreement, the less distortion of geometry there is. This is
calculated by performing dimensionality reduction on the original and quantile aligned (or just
factorized) datasets, and measuring similarity between the k nearest neighbors for each cell in
original and aligned datasets. The Jaccard index is used to quantify similarity, and is the final
metric averages across all cells.

Note that for most datasets, the greater the chosen k, the greater the agreement in general.
There are several options for dimensionality reduction, with the default being 'NMF' as it is
expected to be most similar to iNMF. Although agreement can theoretically approach 1, in practice
it is usually no higher than 0.2-0.3 (particularly for non-deterministic approaches like NMF).
}
\examples{
ligerex <- createLiger(list(ctrl = ctrl, stim = stim))
ligerex <- normalize(ligerex)
ligerex <- selectGenes(ligerex)
ligerex <- scaleNotCenter(ligerex)
# Specification for minimal example run time, not converging
ligerex <- optimizeALS(ligerex, k = 5, max.iters = 1)
ligerex <- quantile_norm(ligerex)
agreement <- calcAgreement(ligerex)
}
