% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rliger.R
\name{createLiger}
\alias{createLiger}
\title{Create a liger object.}
\usage{
createLiger(
  raw.data,
  take.gene.union = FALSE,
  remove.missing = TRUE,
  format.type = "10X",
  data.name = NULL,
  indices.name = NULL,
  indptr.name = NULL,
  genes.name = NULL,
  barcodes.name = NULL,
  verbose = TRUE
)
}
\arguments{
\item{raw.data}{List of expression matrices (gene by cell). Should be named by dataset.}

\item{take.gene.union}{Whether to fill out raw.data matrices with union of genes across all
datasets (filling in 0 for missing data) (requires make.sparse = TRUE) (default FALSE).}

\item{remove.missing}{Whether to remove cells not expressing any measured genes, and genes not
expressed in any cells (if take.gene.union = TRUE, removes only genes not expressed in any
dataset) (default TRUE).}

\item{format.type}{HDF5 format (10X CellRanger by default).}

\item{data.name}{Path to the data values stored in HDF5 file.}

\item{indices.name}{Path to the indices of data points stored in HDF5 file.}

\item{indptr.name}{Path to the pointers stored in HDF5 file.}

\item{genes.name}{Path to the gene names stored in HDF5 file.}

\item{barcodes.name}{Path to the barcodes stored in HDF5 file.}

\item{verbose}{Print messages (TRUE by default)}
}
\value{
\code{liger} object with raw.data slot set.
}
\description{
This function initializes a liger object with the raw data passed in. It requires a list of
expression (or another single-cell modality) matrices (gene by cell) for at least two datasets.
By default, it converts all passed data into sparse matrices (dgCMatrix) to reduce object size.
It initializes cell.data with nUMI and nGene calculated for every cell.
}
\examples{
# Demonstration using matrices with randomly generated numbers
Y <- matrix(runif(5000,0,2), 10,500)
Z <- matrix(runif(5000,0,2), 10,500)
ligerex <- createLiger(list(y_set = Y, z_set = Z))
}
