% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rliger.R
\name{runWilcoxon}
\alias{runWilcoxon}
\title{Perform Wilcoxon rank-sum test}
\usage{
runWilcoxon(object, data.use = "all", compare.method)
}
\arguments{
\item{object}{\code{liger} object.}

\item{data.use}{This selects which dataset(s) to use. (default 'all')}

\item{compare.method}{This indicates the metric of the test. Either 'clusters' or 'datasets'.}
}
\value{
A 10-columns data.frame with test results.
}
\description{
Perform Wilcoxon rank-sum tests on specified dataset using given method.
}
\examples{
\dontrun{
# ligerex (liger object based on in-memory datasets), factorization complete
wilcox.results <- runWilcoxon(ligerex, compare.method = "cluster")
wilcox.results <- runWilcoxon(ligerex, compare.method = "datastes", data.use = c(1, 2))
# HDF5 input
# ligerex (liger object based on datasets in HDF5 format), factorization complete
# Need to sample cells before implementing Wilcoxon test
ligerex <- readSubset(ligerex, slot.use = "norm.data", max.cells = 1000)
de_genes <- runWilcoxon(ligerex, compare.method = "clusters")
}
}
