% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/KrigingClass.R
\name{covMat.Kriging}
\alias{covMat.Kriging}
\alias{covMat,Kriging,Kriging-method}
\title{Compute Covariance Matrix of Kriging Model}
\usage{
\method{covMat}{Kriging}(object, x1, x2, ...)
}
\arguments{
\item{object}{An S3 Kriging object.}

\item{x1}{Numeric matrix of input points.}

\item{x2}{Numeric matrix of input points.}

\item{...}{Not used.}
}
\value{
A matrix of the covariance matrix of the Kriging model.
}
\description{
Compute Covariance Matrix of Kriging Model
}
\examples{
f <- function(x) 1 - 1 / 2 * (sin(12 * x) / (1 + x) + 2 * cos(7 * x) * x^5 + 0.7)
set.seed(123)
X <- as.matrix(runif(10))
y <- f(X)

k <- Kriging(y, X, kernel = "gauss")

x1 = runif(10)
x2 = runif(10)

covMat(k, x1, x2)
}
\author{
Yann Richet \email{yann.richet@asnr.fr}
}
