% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/KrigingClass.R
\name{leaveOneOut.Kriging}
\alias{leaveOneOut.Kriging}
\alias{leaveOneOut,Kriging,Kriging-method}
\title{Get leaveOneOut of Kriging Model}
\usage{
\method{leaveOneOut}{Kriging}(object, ...)
}
\arguments{
\item{object}{An S3 Kriging object.}

\item{...}{Not used.}
}
\value{
The leaveOneOut computed for fitted
    \eqn{\boldsymbol{theta}}{\theta}.
}
\description{
Get leaveOneOut of Kriging Model
}
\examples{
f <- function(x) 1 - 1 / 2 * (sin(12 * x) / (1 + x) + 2 * cos(7 * x) * x^5 + 0.7)
set.seed(123)
X <- as.matrix(runif(10))
y <- f(X)

k <- Kriging(y, X, kernel = "matern3_2", objective="LOO")
print(k)

leaveOneOut(k)
}
\author{
Yann Richet \email{yann.richet@irsn.fr}
}
