% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/connect.R
\name{jsonapi_connect}
\alias{jsonapi_connect}
\title{Connection}
\arguments{
\item{url}{(character) Base url, without the version information,
e.g., \code{http://localhost:8088}}

\item{version}{(character) API version. Default: \code{v1}}

\item{content_type}{(character) the content type to set in all request
headers. Default: application/vnd.api+json}

\item{headers}{(list) A list of headers to be applied to each requset.}

\item{...}{Curl options passed on to \code{\link[crul]{HttpClient}}. You
can set these for all requests, or on each request - see examples.}
}
\description{
Connection
}
\details{
\strong{Methods}
  \describe{
    \item{\code{status(...)}}{
      Check server status with a HEAD request

      \itemize{
       \item ... - curl options
      }
    }
    \item{\code{routes(...)}}{
      Get routes the server supports

      \itemize{
       \item ... - curl options
      }
    }
    \item{\code{route(endpt, query, include, error_handler, ...)}}{
      Fetch a route, optional query parameters

      \itemize{
       \item endpt - The endpoint to request data from. required.
       \item query - a set of query parameters. combined with include
       parameter
       \item include - A comma-separated list of relationship paths.
      combined with query parameter
       \item error_handler - A function for error handling
       \item ... - curl options
      }
    }
  }
}
\examples{
\dontrun{
library("crul")
(conn <- jsonapi_connect("http://localhost:8088"))
conn$url
conn$version
conn$content_type
conn$status()
conn$routes()
conn$routes(verbose = TRUE)

# get data from speicific routes
conn$route("authors")
conn$route("chapters")
conn$route("authors/1")
conn$route("authors/1/books")
conn$route("chapters/5")
conn$route("chapters/5/book")
conn$route("chapters/5/relationships/book")

## include
conn$route("authors/1", include = "books")
conn$route("authors/1", include = "photos")
conn$route("authors/1", include = "photos.title")

## set curl options on jsonapi_connect() call
xx <- jsonapi_connect("http://localhost:8088", verbose = TRUE)
xx$opts
xx$status()

## set headers on initializing the client
(conn <- jsonapi_connect("http://localhost:8088", headers = list(foo = "bar")))

## errors
### route doesn't exist
# conn$route("foobar")

### document doesn't exist
# conn$route("authors/56")
}
}

