% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print_diagnostics.R
\name{print_diagnostics}
\alias{print_diagnostics}
\title{Print the diagnostics}
\usage{
print_diagnostics(
  x,
  format = "latex",
  signif.stars = TRUE,
  tests = c("mean", "skewness", "kurtosis", "ljung box",
    "ljung box (residuals at seasonal lags)", "ljung box (squared residuals)",
    "qs test on sa", "qs test on i", "f-test on sa (seasonal dummies)",
    "f-test on i (seasonal dummies)", "Residual seasonality (entire series)",
    "Residual seasonality (last 3 years)", "f-test on sa (td)", "f-test on i (td)"),
  digits = 3,
  decimal.mark = getOption("OutDec"),
  booktabs = TRUE,
  ...
)
}
\arguments{
\item{x}{the object to print.}

\item{format}{output format: \code{"latex"} or \code{"html"}.}

\item{signif.stars}{logical; if \code{TRUE}, p-values are additionally encoded visually as ‘significance stars’ in order to help scanning of long coefficient tables}

\item{tests}{characters containing the names of the tests to print.}

\item{digits}{number of digits after the decimal point.}

\item{decimal.mark}{the character to be used to indicate the numeric decimal point.}

\item{booktabs}{boolean indicating whether to use or not the booktabs package (when \code{format = "latex"}).}

\item{...}{unused arguments.}
}
\description{
Function to print diagnostics tests on the quality of the pre-processing and the decomposition
}
\examples{
ipi <- RJDemetra::ipi_c_eu[, "FR"]

jsa_x13 <- RJDemetra::jx13(ipi)
print_diagnostics(jsa_x13, format = "latex")

\donttest{
sa_ts <- RJDemetra::tramoseats(ipi)
print_diagnostics(sa_ts, format = "html")
}
}
