% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apps_of_direction.R
\name{upstreamtofrom}
\alias{upstreamtofrom}
\title{Upstream Distance Matrix between Two Datasets}
\usage{
upstreamtofrom(seg1, vert1, seg2, vert2, rivers, logical1 = NULL,
  logical2 = NULL, ID1 = NULL, ID2 = NULL, net = FALSE,
  flowconnected = FALSE, stopiferror = TRUE, algorithm = NULL)
}
\arguments{
\item{seg1}{First vector of river locations (segment component).  These are expressed as rows in the output matrix.}

\item{vert1}{First vector of river locations (vertex component).  These are expressed as rows in the output matrix.}

\item{seg2}{Second vector of river locations (segment component).  These are expressed as columns in the output matrix.}

\item{vert2}{Second vector of river locations (vertex component).  These are expressed as columns in the output matrix.}

\item{rivers}{The river network object to use.}

\item{logical1}{A boolean vector that can be used for subsetting.  If used,
\code{upstreamtofrom} will only return upstream distances in which a
specified condition is met for the first dataset.}

\item{logical2}{A boolean vector that can be used for subsetting.  If used,
\code{upstreamtofrom} will only return upstream distances in which a
specified condition is met for the second dataset.}

\item{ID1}{a vector of observation IDs for the first dataset that will be used as row names in the output matrix.}

\item{ID2}{a vector of observation IDs for the second dataset that will be used as column names in the output matrix.}

\item{net}{Whether to calculate net upstream distance (\code{TRUE}) or signed total distance (\code{FALSE}).  See \link{upstream}.}

\item{flowconnected}{If \code{TRUE}, only returns distance if the input segments are flow-connected.  Defaults to \code{FALSE}.}

\item{stopiferror}{Whether or not to exit with an error if a route cannot be
found.  If this is set to \code{FALSE} and a route cannot be found,
the function will return \code{NA} in the appropriate entry.  Defaults to \code{TRUE}.  See \link{detectroute}.}

\item{algorithm}{Which route detection algorithm to use (\code{"Dijkstra"},
\code{"sequential"}, or \code{"segroutes"}).  If left as \code{NULL} (the
default), the function will automatically make a selection.  See
\link{detectroute} for more details.}
}
\value{
A matrix of upstream distances (numeric) with rows and columns labeled by corresponding values of \code{ID}.  See \link{upstream} for additional information.
}
\description{
Returns a matrix of upstream distances between each river location in two datasets, with one expressed as rows and the other expressed as columns.
}
\note{
Building routes from the river mouth to each river network segment may greatly reduce computation time (see \link{buildsegroutes}).
}
\examples{
data(Gulk)

streamlocs.seg <- c(1,8,11)
streamlocs.vert <- c(50,70,90)
streamlocs.ID <- c("A","B","C")

fish.seg <- c(1,4,9,12,14)
fish.vert <- c(10,11,12,13,14)
fish.ID <- c("fish1","fish2","fish3","fish4","fish5")

Gulk <- setmouth(seg=1, vert=1, rivers=Gulk)

upstreamtofrom(seg1=streamlocs.seg, vert1=streamlocs.vert,
  seg2=fish.seg, vert2=fish.vert, rivers=Gulk,
  ID1=streamlocs.ID, ID2=fish.ID)

logi1 <- streamlocs.ID=="B" | streamlocs.ID=="C"
logi2 <- fish.ID!="fish3"

upstreamtofrom(seg1=streamlocs.seg, vert1=streamlocs.vert,
  seg2=fish.seg, vert2=fish.vert, rivers=Gulk, logical1=logi1,
  logical2=logi2, ID1=streamlocs.ID, ID2=fish.ID)
}
\author{
Matt Tyers
}
\seealso{
\link{upstream}
}

