% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/init_pal.R
\docType{data}
\name{pal_mbw}
\alias{pal_mbw}
\title{Modern and reduced color palette (in green/blue/bw).}
\format{
An object of class \code{character} of length 16.
}
\usage{
pal_mbw
}
\description{
\code{pal_mod} is initialized to a vector of named colors
to define a reduced modern scenario color scheme (in green/blue/bw).
}
\details{
See \code{\link{pal_org}} for original color information;
\code{\link{pal_mod}} for a richer modern color palette; and
\code{\link{pal_bw}} for a more reduced black-and-white color palette.

Assign \code{pal <- pal_mbw} to use as default color scheme
throughout the \bold{riskyr} package.
}
\examples{
pal_mbw        # shows all color names and current values
pal_mbw["hi"]  # shows the current color for hits (true positives, TP)
pal_mbw["hi"] <- "gold" # defines a new color for hits (true positives, TP)

}
\seealso{
\code{\link{pal}} contains current color information;
\code{\link{init_pal}} initializes color information;
\code{\link{pal_org}} for original color palette;
\code{\link{pal_mod}} for a richer modern color palette;
\code{\link{pal_bw}} for a more reduced black-and-white color palette.

Other color palettes: 
\code{\link{pal_bwp}},
\code{\link{pal_bw}},
\code{\link{pal_crisk}},
\code{\link{pal_kn}},
\code{\link{pal_mod}},
\code{\link{pal_org}},
\code{\link{pal_rgb}},
\code{\link{pal_unikn}},
\code{\link{pal_vir}}

Other lists containing current scenario information: 
\code{\link{accu}},
\code{\link{freq}},
\code{\link{num}},
\code{\link{pal_bwp}},
\code{\link{pal_bw}},
\code{\link{pal_kn}},
\code{\link{pal_mod}},
\code{\link{pal_org}},
\code{\link{pal_rgb}},
\code{\link{pal_unikn}},
\code{\link{pal_vir}},
\code{\link{pal}},
\code{\link{prob}},
\code{\link{txt_TF}},
\code{\link{txt_org}},
\code{\link{txt}}
}
\concept{color palettes}
\concept{lists containing current scenario information}
\keyword{datasets}
