% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/risk_mod.R
\name{risk_mod}
\alias{risk_mod}
\title{Fit an Integer Risk Score Model}
\usage{
risk_mod(
  X,
  y,
  gamma = NULL,
  beta = NULL,
  weights = NULL,
  lambda0 = 0,
  a = -10,
  b = 10,
  max_iters = 100,
  tol = 1e-05,
  shuffle = TRUE,
  seed = NULL
)
}
\arguments{
\item{X}{Input covariate matrix with dimension \eqn{n \times p};
every row is an observation.}

\item{y}{Numeric vector for the (binomial) response variable.}

\item{gamma}{Starting value to rescale coefficients for prediction (optional).}

\item{beta}{Starting numeric vector with \eqn{p} coefficients.
Default starting coefficients are rounded coefficients from a
logistic regression model.}

\item{weights}{Numeric vector of length \eqn{n} with weights for each
observation. Unless otherwise specified, default will give equal weight to
each observation.}

\item{lambda0}{Penalty coefficient for L0 term (default: 0).
See \code{\link[=cv_risk_mod]{cv_risk_mod()}} for \code{lambda0} tuning.}

\item{a}{Integer lower bound for coefficients (default: -10).}

\item{b}{Integer upper bound for coefficients (default: 10).}

\item{max_iters}{Maximum number of iterations (default: 100).}

\item{tol}{Tolerance for convergence (default: 1e-5).}

\item{shuffle}{Whether order of coefficients is shuffled during coordinate
descent (default: TRUE).}

\item{seed}{An integer that is used as argument by \code{set.seed()} for
offsetting the random number generator. Default is to not set a
particular randomization seed.}
}
\value{
An object of class "risk_mod" with the following attributes:
\item{gamma}{Final scalar value.}
\item{beta}{Vector of integer coefficients.}
\item{glm_mod}{Logistic regression object of class "glm" (see \link[stats:glm]{stats::glm}).}
\item{X}{Input covariate matrix.}
\item{y}{Input response vector.}
\item{weights}{Input weights.}
\item{lambda0}{Imput \code{lambda0} value.}
\item{model_card}{Dataframe displaying the nonzero integer coefficients
(i.e. "points") of the risk score model.}
\item{score_map}{Dataframe containing a column of possible scores and a column
with each score's associated risk probability.}
}
\description{
Fits an optimized integer risk score model using a cyclical coordinate descent
algorithm. Returns an object of class "risk_mod".
}
\details{
This function uses a cyclical coordinate descent algorithm to solve the
following optimization problem.

\deqn{\min_{\alpha,\beta} \quad \frac{1}{n} \sum_{i=1}^{n} (\gamma y_i x_i^T \beta - log(1 + exp(\gamma x_i^T \beta))) + \lambda_0 \sum_{j=1}^{p} 1(\beta_{j} \neq 0)}

\deqn{l \le \beta_j \le u \; \; \; \forall j = 1,2,...,p}
\deqn{\beta_j \in \mathbb{Z} \; \; \; \forall j = 1,2,...,p }
\deqn{\beta_0, \gamma \in \mathbb{R}}

These constraints ensure that the model will be sparse and include
only integer coefficients.
}
\examples{
y <- breastcancer[[1]]
X <- as.matrix(breastcancer[,2:ncol(breastcancer)])

mod1 <- risk_mod(X, y)
mod1$model_card

mod2 <- risk_mod(X, y, lambda0 = 0.01)
mod2$model_card

mod3 <- risk_mod(X, y, lambda0 = 0.01, a = -5, b = 5)
mod3$model_card
}
